<?php
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwDesignService.php 17956 2012-09-10 10:47:52Z gao.wanggao $ 
 * @package 
 */
class PwDesignService {
	
	public function getModelList() {
		$modelList = array();
		$list = WindFolder::read(Wind::getRealDir('SRV:design.srv.model'), WindFolder::READ_DIR);
		$_configParser = Wind::getApp()->getComponent('configParser');
		foreach ($list AS $model) {
			$configPath = Wind::getRealPath('SRV:design.srv.model.'.$model. '.config');
			if (!is_file($configPath)) continue;
			$config = $_configParser->parse($configPath);
			if (!isset($config['model'])) continue;
			$modelList[$config['model']] = array('name'=>$config['name'],'type'=>$config['type']);
		}
		return $modelList;
	}
	
	public function getDesignModelType($select = '') {
		$array = array(
			'bbs'	=>'论坛模型',
			'user'	=>'用户模型',
			'space'	=>'空间模型',
			'other'	=>'其它模型',
			'api'	=>'扩展模型'
		);
		return $select ? $array[$select] : $array;
	}
	
	public function getSysListClass($select = '') {
		$array = array(
			'默认'	=>'',
			/*'样式1' =>'mod_boxA',
			'样式2' =>'mod_boxB',
			'样式3' =>'mod_boxC',
			'样式4' =>'mod_boxD',
			'样式5' =>'mod_boxE',*/
		);
		return $select ? $array[$select] : $array;
	}
	
	public function getSysStyleClass($select = '') {
		$array = array(
			'默认'	=>'box_wrap',
			'无样式'	=>'box_no',
			'样式1'	=>'boxB_wrap',
			'样式2'	=>'boxC_wrap',
			'样式3'	=>'boxD_wrap',
		);
		return $select ? $array[$select] : $array;
	}
	
	public function getSysFontSize($select = '') {
		$array = array(10,12,14,16,18,20);
		return $select ? $select : $array;
	}
	
	public function getSysLineWidth($select = '') {
		$array = array(0,1,2,3,4,5,6,7,8,9,10);
		return $select ? $select : $array;
	}
	
	public function getSysBorderStyle($select = '') {
		$array = array(
			'solid'		=>'实线',
			'dotted'	=>'点线',
			'dashed'	=>'虚线',
			'double'	=>'双实线'
		);
		return $select ? $array[$select] : $array;
	}
	
	public function getStandardSignkey($model) {
		Wind::import('SRV:design.bo.PwDesignModelBo');
		$bo = new PwDesignModelBo($model);
		$signKeys = $bo->getSignKeys();
		$standard = $bo->getStandardSign();
		foreach ($standard AS &$v){
			$v = $this->_transformSign($v);
		}
		return $standard;
	}
	
	/**
	 * 获取模型自定义标签
	 * Enter description here ...
	 * @param string $string
	 */
	public function getModelSignkey($string) {
		$array = explode(',', $string);
		$signKey = array();
		if (!is_array($array) || count($array) < 1) return array();
		foreach ($array AS $v) {
			list($key,$sign) = explode('=', $v);
			$signKey[$key] =$sign;
		}
		return $signKey;
	}
	
	/**
	 * 判断提交的模块模版是否合法
	 * Enter description here ...
	 * @param string $string
	 */
	public function checkTemplate($string) {
		$isModule = $isTpl = true;
		if(!preg_match('/\<design\s*id=\"*D_mod_(\d+)\"*\s*role=\"*module\"*\s*[>|\/>]<\/design>/isU', $string, $matches)) {
			$isModule = false;
		}
		if(!preg_match('/\<for:>(.*)<\/for>/isU', $string, $matches)) {
			$isTpl = false;
		}
		if (!$isModule && !$isTpl) return false;
		//TODO过滤白名单
		return true;
	}
	
	/**
	 *	过滤白名单
	 */
	public function filterTemplate($string) {
		$in = array(
			'<\?php.*?\?>/is',
		);
	}

	private function _transformSign($sign) {
		if(!preg_match('/\{(.+)}/isU', $sign, $matches)) return false;
		return $matches[1];
	}
}
?>