<?php
Wind::import('SRV:design.bo.PwDesignModuleBo');
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwModuleData.php 17840 2012-09-10 05:21:44Z gao.wanggao $ 
 * @package 
 */
class PwModuleData {

	protected $bo;
	protected $time;
	
	protected $sourData = array();
	protected $multiSign = array();
	protected $designData = array();
	
	protected $pushids = array();
	protected $autoids = array();
	
	public function __construct($moduleid) {
		$this->bo = new PwDesignModuleBo($moduleid);
		$this->time = Pw::getTime();
	}
	
	/**
	 * 对排序进行修正
	 * Enter description here ...
	 */
	public function reviseOrder() {
		$fixed = array();
		$data = Wekit::load('design.PwDesignData')->getDataByModuleid($this->bo->moduleid);
		foreach ($data AS $k=>$v) {
			if($v['data_type'] == 2) $fixed[] = $v['vieworder'];
		}
		if (!$fixed) return true;
		$i = 1;
		$ds = Wekit::load('design.PwDesignData');
		foreach ($data AS $k=>$v) {
			if($v['data_type'] == 2) continue;
			while(in_array($i, $fixed)) {
				$i++;
			}
			$ds->updateOrder($v['data_id'], $i);
			$i++;
		}
		return true;
	}
	
	/**
	 * 根据指定ID获取数据
	 * 用于推送数据获取
	 * @param int|array $fromid
	 */
	public function buildDataByIds($fromid) {				
		$model = $this->bo->getModel();
		if (!is_array($fromid)) $fromid = array($fromid);
		$cls = sprintf('PwDesign%sDataService', ucwords($model));
		$service = Wekit::load('design.srv.model.'.$model.'.'.$cls);
		$service->setModuleBo($this->bo);
		$data = $service->buildDataByIds($fromid);
		if (!$data) return array();
		foreach ($data AS  $k=>$v) {
			$data[$k]['extend'] = $this->getExtend($v);
		}
		return  $data;
	}


	
	protected function setDesignData() {
		$delDataIds = $_data = array();
		$ds = Wekit::load('design.PwDesignData');
		$data = $ds->getDataByModuleid($this->bo->moduleid);
		$limit = $this->getLimit();
		foreach ($data AS $v) {
			if ($v['is_reservation'] && $v['start_time'] <= $this->time){
				$ds->updateReservation($v['data_id'], 0);
				$v['is_reservation'] = 0;
			}
			if ($v['data_type'] == PwDesignData::AUTO) {
				$delDataIds[] = $v['data_id'];
				$_data[] = array();
				continue;
			}
			if ($v['end_time'] > 0 && $v['end_time'] < $this->time) {
				$delDataIds[] = $v['data_id'];
				$_data[] = array();
				continue;
			} 
			if ($v['from_type'] == PwDesignData::FROM_PUSH ) {
				$this->pushids[] = $v['from_id'];
			} else {
				$this->autoids[] = $v['from_id'];
			}
			$_data[] = $v;
		}
		$ds->batchDelete($delDataIds);
		//格式化门户数据系列，无数据的补空；
		for($i = 0; $i < $limit; $i++) {
			$this->designData[] = isset($_data[$i]) ? $_data[$i] : array();
		}
		
	}

	
	
	protected function getLimit() {
		//if ($this->_limit) return $this->_limit;
		return $this->bo->getLimit();
	}
	
	/**
	 * 过滤不需要的data
	 * Enter description here ...
	 * @param array $data
	 */
	protected function getExtend($data) {
		$_data = array();
		$params = $this->getComponentValue($this->bo->getTemplate(), implode('', $this->bo->getStandardSign()));
		$data = $this->cutImg($data);
		foreach($params AS $param) {
			//if (in_array($param, array('title','fromid','url','bold','underline', 'italic', 'color')))unset($param);
			if (isset($data[$param]))$_data[$param] = $data[$param];
		}		
		return $_data;
	}
	
	/**
	 * 生成门户图片
	 * Enter description here ...
	 * @param array $data
	 */
	protected function cutImg($data) {
		if (!$this->multiSign['img']) return $data;
		$srv = Wekit::load('design.srv.PwDesignImage');
		foreach ($this->multiSign['img'] AS $k=>$v) {
			if (!$data[$k]) continue;
			list($thumbW, $thumbH) = $v;
			if ($thumbW < 1 && $thumbH < 1) {
				$data[$k] = Wekit::app()->attach . '/' . $data[$k];
			} else {
				$srv->setInfo($this->bo->moduleid, $data[$k], $thumbW, $thumbH);
				$data[$k] = $srv->cut();
			}
		}
		return $data;
	}
	
	protected function getComponentValue($string, $standardSign) {
		$string .= $standardSign;
		//对三元标签（图片）进行处理
		if(preg_match_all('/\{(\w+)\|(\d+)\|(\d+)}/U', $string, $matche)) {
			foreach ($matche[1] AS $k=>$v) {
				//if ($matche[2][$k] || $matche[3][$k]) {
				$this->multiSign['img'][$v] = array($matche[2][$k],$matche[3][$k]);
				//}
    			$string = str_replace($matche[0][$k], '{'.$v.'}', $string);
    		}
		}
		//对二元标签进行处理
		if(preg_match_all('/\{(\w+)\|(\w+)}/U', $string, $matche)) {
			foreach ($matche[1] AS $k=>$v) {
    			$string = str_replace($matche[0][$k], '{'.$v.'}', $string);
    		}
		}
		
		//对二元标签进行处理
		if(preg_match_all('/\{(\w+)\|(\d+)}/U', $string, $matche)) {
			foreach ($matche[1] AS $k=>$v) {
    			$string = str_replace($matche[0][$k], '{'.$v.'}', $string);
    		}
		}
		
		if(!preg_match_all('/\{(\w+)}/isU', $string, $matches)) return array();
		return array_unique($matches[1]);
	}
	
	/**
	 * 格式化推送数据用于Data插入
	 * Enter description here ...
	 */
	protected function formatPushData($data) {
		$_data = array();
		$_data['standard_title'] = $data['push_id'];
		$_data['standard_fromid'] = $data['push_id'];
		$_data['standard_fromapp'] = $data['push_from_model'];
		$_data['standard'] = unserialize($data['push_standard']);
		$_data['style'] = $data['push_style'];
		$_data['vieworder'] = $data['push_orderid'];
		$_data['start_time'] = $data['start_time'];
		$_data['end_time'] = $data['end_time'];
		$_data['from_type'] = 'push';
		$extend = unserialize($data['push_extend']);
		$_data = array_merge($_data, $extend); 
		return $_data;
	}
	
	/**
	 * 转换data数据用于更新
	 * Enter description here ...
	 */
	protected function formatDesginData($data) {
		$_data = array();
		$_data['standard_title'] = $data['from_id'];
		$_data['standard_fromid'] = $data['from_id'];
		$_data['standard_fromapp'] = $data['from_app'];
		$_data['standard'] = unserialize($data['standard']);
		$_data['style'] = $data['style'];
		$_data['vieworder'] = $data['vieworder'];
		$_data['start_time'] = $data['start_time'];
		$_data['end_time'] = $data['end_time'];
		$extend = unserialize($data['extend_info']);
		$_data = array_merge($_data, $extend); 
		return $_data;
	}

}
?>