<?php
Wind::import("Lib:utility.PwCacheService");
/**
 * 域名service 
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwDomainService.php 17812 2012-09-10 02:14:19Z long.shi $
 * @package domain.srv
 */
class PwDomainService {
	
	/**
	 * 获取二级域名设置的扩展
	 *
	 * @return array
	 */
	public function getAddOns($type = 'domain') {
		$r = @include Wind::getRealPath("APPS:rewrite.conf.$type.php", true);
		return $r ? $r : array();
	}
	
	/**
	 * 清除tpl缓存
	 *
	 * @return boolean
	 */
	public function refreshTplCache() {
		WindFolder::rm(Wind::getRealDir('DATA:compile.template'), true);
		WindFolder::rm(Wind::getRealDir('DATA:design.template'), true);
		return true;
	}
	
	/**
	 * 获取域名缓存服务
	 *
	 * @return PwCacheService
	 */
	public function getDomainCache() {
		static $instance = null;
		if ($instance === null) {
			$instance = new PwCacheService('default', PwCacheService::STRATEGY_DBCACHE);
		}
		return $instance;
	}
	
	/**
	 * 检测域名是否合法
	 *
	 * @param string $domain
	 * @param string $root 根域名
	 * @return PwError|boolean
	 */
	public function isDomainValid($domain, $root, $key) {
		$len = strlen($domain);
		if ($len < 3 || $len > 20) return new PwError('REWRITE:domain.length');
		if ($domain[0] < 'a' || $domain[0] > 'z') return new PwError('REWRITE:domain.first.illegal');
		if (!preg_match('/^[a-z0-9]+$/', $domain)) return new PwError('REWRITE:domain.char.num');
		$result = $this->_domainDs()->getByDomainAndRoot($domain, $root);
		if ($result && $result['domain_key'] != $key)
			return new PwError('REWRITE:domain.exist');
		$domain_hold = Wekit::config('domain', 'domain.hold');
		$holds = explode(',', $domain_hold);
		foreach ($holds as $v) {
			$preg = str_replace('*', '.*?', $v);
			if (preg_match("/^$preg$/i", $domain))
				return new PwError(array('REWRITE:domain.hold', array($v)));
		}
		return true;
	}
	
	/**
	 * 检测域名是否合法
	 *
	 * @param unknown_type $domain
	 * @param unknown_type $type
	 * @param unknown_type $key
	 * @return PwError|boolean
	 */
	public function isNameValid($domain, $key) {
		$len = strlen($domain);
		if ($len < 3 || $len > 20) return new PwError('REWRITE:domain.length');
		if ($domain[0] < 'a' || $domain[0] > 'z') return new PwError('REWRITE:domain.first.illegal');
		if (!preg_match('/^[a-z0-9]+$/', $domain)) return new PwError('REWRITE:domain.char.num');
		$result = $this->_domainDs()->getByDomain($domain);
		if (count($result) > 1 || ($result && $result[0]['domain_key'] != $key))
			return new PwError('REWRITE:domain.exist');
		$domain_hold = Wekit::config('domain', 'domain.hold');
		$holds = explode(',', $domain_hold);
		foreach ($holds as $v) {
			$preg = str_replace('*', '.*?', $v);
			if (preg_match("/^$preg$/i", $domain))
				return new PwError(array('REWRITE:domain.hold', array($v)));
		}
		return true;
	} 
	
	/**
	 * 更新应用域名缓存
	 *
	 */
	public function refreshAppCache() {
		$app = array();
		$result = $this->_domainDs()->getByType('app');
		foreach ($result as $v) {
			$k = 'http://'. $v['domain'] . '.' . $v['root'];
			list(, , $m) = WindUrlHelper::resolveAction($v['domain_key']);
			$app[$m] = $k;
		}
		$this->getDomainCache()->set('domain_app', $app);
	}
	
	/**
	 * 更新域名所有缓存
	 *
	 */
	public function refreshAllCache() {
		$this->refreshAppCache();
		foreach (range('a', 'z') as $l) {
			$this->refreshCacheByFirst($l);
		}
		$this->refreshTplCache();
	}
	
	/**
	 * 更新某个首字母的缓存
	 *
	 * @param char $first
	 */
	public function refreshCacheByFirst($first, $type) {
		$domain = array();
		$result = $this->_domainDs()->getByFirst($first);
		foreach ($result as $v) {
			if ($v['domain_type'] == 'app' || Wekit::config('domain', "{$v['domain_type']}.isopen")) {
				$k = 'http://'. $v['domain'] . '.' . $v['root'];
				$domain[$k] = $v['domain_key'];
			}
		}
		$this->getDomainCache()->set("domain_$first", $domain);
	}
	
	/**
	 * @return PwDomain
	 */
	private function _domainDs() {
		return Wekit::load('domain.PwDomain');
	}
}

?>