<?php

/**
 * 帖子索引dao服务
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwThreadsCateIndexDao.php 17054 2012-08-30 10:51:39Z jieyin $
 * @package forum
 */

class PwThreadsCateIndexDao extends PwBaseDao {
	
	protected $_table = 'bbs_threads_cate_index';
	protected $_pk = 'tid';
	protected $_dataStruct = array('tid', 'cid', 'fid', 'disabled', 'created_time', 'lastpost_time');

	public function count($cid) {
		$sql = $this->_bindTable('SELECT count(*) as count FROM %s WHERE cid=? AND disabled=0');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($cid));
	}

	public function countNotInFids($cid, $fids) {
		$sql = $this->_bindSql('SELECT count(*) as count FROM %s WHERE cid=? AND disabled=0 AND fid NOT IN %s', $this->getTable(), $this->sqlImplode($fids));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($cid));
	}
	
	public function fetch($cid, $limit, $offset, $order) {
		list($field, $idx) = $this->_getOrderFieldAndIndex($order);
		$sql = $this->_bindSql('SELECT * FROM %s FORCE INDEX(%s) WHERE cid=? AND disabled=0 ORDER BY %s DESC %s', $this->getTable(), $idx, $field, $this->sqlLimit($limit, $offset));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($cid), 'tid');
	}
	
	public function fetchNotInFid($cid, $fids, $limit, $offset, $order) {
		list($field, $idx) = $this->_getOrderFieldAndIndex($order);
		$sql = $this->_bindSql('SELECT * FROM %s FORCE INDEX(%s) WHERE cid=? AND disabled=0 AND fid NOT IN %s ORDER BY %s DESC %s', $this->getTable(), $idx, $this->sqlImplode($fids), $field, $this->sqlLimit($limit, $offset));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($cid), 'tid');
	}

	/*
	public function fetchNotInFid($fids, $limit, $offset, $order) {
		list($field, $idx) = $this->_getOrderFieldAndIndex($order);
		$sql = $this->_bindSql('SELECT * FROM %s FORCE INDEX(%s) WHERE fid NOT IN %s AND disabled=0 ORDER BY %s DESC %s', $this->getTable(), $idx, $this->sqlImplode($fids), $field, $this->sqlLimit($limit, $offset));
		$smt = $this->getConnection()->query($sql);
		return $smt->fetchAll('tid');
	}

	public function countThreadNotInFids($fids) {
		$sql = $this->_bindSql('SELECT count(*) as count FROM %s WHERE fid NOT IN %s AND disabled=0', $this->getTable(), $this->sqlImplode($fids));
		$smt = $this->getConnection()->query($sql);
		return $smt->fetchColumn();
	}*/

	protected function _getOrderFieldAndIndex($order) {
		if ($order == 'lastpost') {
			return array('lastpost_time', 'idx_cid_lastposttime');
		}
		return array('tid', 'PRIMARY');
	}
	
	public function addThread($tid, $fields) {
		$fields['tid'] = $tid;
		$fields = $this->_processField($fields);
		return $this->_add($fields, false);
	}

	public function updateThread($tid, $fields, $increaseFields = array()) {
		$fields = $this->_processField($fields);
		return $this->_update($tid, $fields, $increaseFields);
	}

	public function batchUpdateThread($tids, $fields, $increaseFields = array()) {
		$fields = $this->_processField($fields);
		return $this->_batchUpdate($tids, $fields, $increaseFields);
	}
	
	public function deleteThread($tid) {
		return $this->_delete($tid);
	}

	public function batchDeleteThread($tids) {
		return $this->_batchDelete($tids);
	}

	public function deleteOver($cid, $limit) {
		$sql = $this->_bindSql('DELETE FROM %s WHERE cid=? ORDER BY lastpost_time ASC LIMIT %s', $this->getTable(), intval($limit));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($cid));
	}

	private function _processField($fields) {
		if (isset($fields['fid'])) {
			$fields['cid'] = $fields['fid'] ? Wekit::load('forum.srv.PwForumService')->getCateId($fields['fid']) : 0;
		}
		return $fields;
	}
}