<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('SRV:forum.bo.PwThreadBo');
Wind::import('SRV:forum.bo.PwForumBo');
Wind::import('SRV:forum.srv.threadDisplay.PwAttachDisplay');
Wind::import('LIB:ubb.PwUbbCode');
Wind::import('LIB:ubb.config.PwUbbCodeConvertThread');

/**
 * 帖子显示流程
 *
 * -> 1.check 检查帖子显示运行环境
 * -> 2.appendDo(*) 增加帖子显示时的行为动作,例:投票、悬赏等(可选)
 * -> 3.execute 数据准备
 * -> 4.get... 获取数据以满足页面显示要求
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwThreadDisplay.php 17968 2012-09-10 11:48:42Z jieyin $
 * @package forum
 */

class PwThreadDisplay extends PwBaseHookService {

	public $page = 1;
	public $perpgae = 20;
	public $total = 0;
	public $maxpage;

	public $tid;
	public $fid;
	public $isBM;
	public $readdb = array();

	public $user;	//PwUserBo
	public $thread;	//PwThreadBo
	public $forum;	//PwForumBo
	public $attach;	//PwAttachDisplay
	
	protected $_ds;
	protected $users = array();
	protected $area = array();
	protected $_floorName;
	protected $_definedFloorName;

	public function __construct($tid, PwUserBo $user) {
		$this->thread = new PwThreadBo($tid);
		$this->tid = $tid;
		$this->fid = $this->thread->fid;
		$this->forum = new PwForumBo($this->fid);
		$this->user = $user;
		$this->isBM = $this->forum->isBM($this->user->username);
		$config = Wekit::config('bbs');
		$this->_floorName = $config['read.floor_name'];
		$this->_definedFloorName = $this->_parseDefindFloorName($config['read.defined_floor_name']);
		parent::__construct();
	}
	
	public function check() {
		if (!$this->thread->isThread()) {
			return new PwError('BBS:forum.thread.exists.not');
		}
		if (!$this->forum->isForum()) {
			return new PwError('BBS:forum.exists.not');
		}
		if (($result = $this->forum->allowVisit($this->user)) !== true) {
			return new PwError('BBS:forum.permissions.visit.allow', array('{grouptitle}' => $this->user->getGroupInfo('name')));
		}
		if (($result = $this->forum->allowRead($this->user)) !== true) {
			return new PwError('BBS:forum.permissions.read.allow', array('{grouptitle}' => $this->user->getGroupInfo('name')));
		}
		if (!$this->forum->foruminfo['allow_read'] && !$this->user->getPermission('allow_read') && $_COOKIE) {
			return new PwError('permission.read.allow', array('{grouptitle}' => $this->user->getGroupInfo('name')));
		}
		if ($this->thread->isDeleted()) {
			return new PwError('BBS:forum.thread.deleted');
		}
		if (!$this->thread->isChecked() && $this->thread->authorid != $this->user->uid && !$this->isBM) {
			$permission = $this->user->getPermission('panel_bbs_manage');
			if (!$permission['thread_check']) return new PwError('BBS:forum.thread.ischeck');
		}
		if ($this->thread->info['tpcstatus'] && Pw::getstatus($this->thread->info['tpcstatus'], PwThread::STATUS_CLOSED)) {
			return new PwError('BBS:forum.thread.closed');
		}
		return true;
	}

	public function execute(PwReadDataSource $ds) {
		$this->_ds = $ds;
		$ds->execute();
		$this->total = $ds->total;
		$this->page = $ds->page;
		$this->perpage = $ds->perpage;
		$this->maxpage = $ds->maxpage;
		$start = $ds->firstFloor;
		$this->_initAttachs($ds->getAttach());
		$this->_initUsers($ds->getUser());
		$this->readdb =& $ds->getData();
		foreach ($this->readdb as $key => $read) {
			$this->readdb[$key] = $this->bulidRead($read, $start++);
		}
		$this->thread->hit();
	}
	
	public function bulidRead($read, $lou) {
		$read['lou'] = $lou;
		$read['content'] = WindSecurity::escapeHTML($read['content']);
		$read['content'] = str_replace("\n", '<br />', $read['content']);

		if ($read['ifshield']) {
			$read['content'] = '<span class="b">此帖已被屏蔽</span>';
		} elseif ($read['useubb']) {
			$ubb = new PwUbbCodeConvertThread($this->thread, $read, $this->user);
			$this->attach && $this->attach->has($read['pid']) && $ubb->setAttachParser($this->attach);
			$read['reminds'] && $ubb->setRemindUser($read['reminds']);
			$read['content'] = PwUbbCode::convert($read['content'], $ubb);
		}
		if ($this->user->getPermission('view_ip_address') && $read['created_ip']){
			$read['ipfrom'] = $this->getIpService()->getIpFrom($read['created_ip']);
		}
		$read = $this->runWithFilters('bulidRead', $read);
		return $read;
	}

	public function getThreadInfo() {
		return $this->thread->getThreadInfo();
	}

	public function getList() {
		return $this->readdb;
	}

	public function getForum() {
		return $this->forum;
	}

	public function getUsers() {
		return $this->users;
	}

	public function getArea() {
		return $this->area;
	}

	public function displayHtmlFromBeforeContent($read) {
		$this->runDo('createHtmlBeforeContent', $read);
	}

	public function displayHtmlFromAfterContent($read) {
		$this->runDo('createHtmlAfterContent', $read);
	}

	public function getFloorName($lou) {
		return isset($this->_definedFloorName[$lou]) ? $this->_definedFloorName[$lou] : $lou . $this->_floorName;
	}

	public function getTopicTypeName($id) {
		$array = $this->_getTopicTypeDs()->getTopicType($id);
		return $array['name'];
	}
	
	public function getIpService(){
		return Wekit::load('LIB:utility.PwIptable');
	}

	public function getHeadguide() {
		return $this->forum->headguide()
			. $this->forum->bulidGuide(array(Pw::substrs($this->thread->info['subject'], 30), WindUrlHelper::createUrl('bbs/read/run?tid=' . $this->tid . '&fid=' . $this->fid)));
	}

	public function getUrlArgs($except = '') {
		return $this->_ds->getUrlArgs($except);
	}

	protected function _parseDefindFloorName($string) {
		$array = array(0 => '楼主');
		$_tmp = explode("\n", $string);
		foreach ($_tmp as $value) {
			list($key, $name) = explode(':', trim($value));
			$names = explode(',', $name);
			foreach ($names as $v) {
				$array[$key++] = $v;
			}
		}
		return $array;
	}

	protected function _initAttachs($pids) {
		if (empty($pids)) return;
		$this->attach = new PwAttachDisplay($this->tid, $pids, $this->user);
	}

	protected function _initUsers($uids) {
		$hasArea = array_intersect(array('location', 'hometown'), array_keys(Wekit::config('bbs', 'read.display_info')));
		$areaids = array();
		$users = Wekit::load('user.PwUser')->fetchUserByUid($uids, PwUser::FETCH_ALL);
		in_array('0', $uids) && $users['0'] = $this->_getGuestInfo();
		foreach ($users as $key => $value) {
			$value['groupid'] == '0' && $value['groupid'] = $value['memberid'];
			$users[$key] = $value;
			in_array('location', $hasArea) && $areaids[] = $value['location'];
			in_array('hometown', $hasArea) && $areaids[] = $value['hometown'];
		}
		if ($areaids) {
			$this->area = Wekit::load('area.srv.PwAreaService')->fetchAreaInfo($areaids);
		}
		$this->users = $users;
	}

	protected function _getGuestInfo() {
		$info = array(
			'groupid'	=> 1,
			'postnum'	=> 0,
			'fans'		=> 0,
			'follows'	=> 0,
			'lastvisit' => Pw::getTime()
		);
		Wind::import('SRV:credit.bo.PwCreditBo');
		foreach (PwCreditBo::getInstance()->cType as $key => $value) {
			$info['credit' . $key] = 0;
		}
		return $info;
	}

	protected function _getTopicTypeDs() {
		return Wekit::load('forum.PwTopicType');
	}

	protected function _getInterfaceName() {
		return 'PwThreadDisplayDoInterface';
	}
}