<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('LIB:ubb.PwSimpleUbbCode');
Wind::import('LIB:ubb.config.PwUbbCodeConvertThread');

/**
 * 帖子公共服务
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: PwThreadService.php 15354 2012-08-03 09:29:10Z jieyin $
 * @package forum
 */

class PwThreadService {
	
	public function displayReplylist($replies, $contentLength = 140) {
		foreach ($replies as $key => $value) {
			$value['content'] = WindSecurity::escapeHTML($value['content']);
			if ($value['useubb']) {
				$ubb = new PwUbbCodeConvertThread();
				$value['reminds'] && $ubb->setRemindUser($value['reminds']);
				$value['content'] = PwSimpleUbbCode::convert($value['content'], $contentLength, $ubb);
			} else {
				$value['content'] = Pw::substrs($value['content'], $contentLength);
			}
			$replies[$key] = $value;
		}
		return $replies;
	}

	public function displayContent($content, $useubb, $remindUser = array(), $contentLength = 140) {
		$content = WindSecurity::escapeHTML($content);
		if ($useubb) {
			$ubb = new PwUbbCodeConvertThread();
			$ubb->setRemindUser($remindUser);
			$content = PwSimpleUbbCode::convert($content, $contentLength, $ubb);
		} else {
			$content = Pw::substrs($content, $contentLength);
		}
		return $content;
	}
}