<?php
/**
 * Enter description here ...
 * 
 * @author peihong.zhangph <peihong.zhangph@aliyun-inc.com> Dec 13, 2011
 * @link http://www.phpwind.com
 * @copyright 2011 phpwind.com
 * @license
 * @version $Id: PwManageDelete.php 13278 2012-07-05 02:08:39Z jieyin $
 */

Wind::import('SRV:forum.srv.manage.PwManageAction');
Wind::import('SRV:forum.dm.PwTopicDm');
Wind::import('SRV:forum.srv.operation.PwDeleteTopic');
Wind::import('SRV:forum.srv.dataSource.PwFetchTopicByTid');

class PwManageDelete extends PwManageAction {
	
	public $deleteCredit = false; //扣除积分
	public $recycle = false;
	public $threadsInfo;
	public $service;
	
	public function __construct($tids, $user = null) {
		//$this->threadsInfo = $this->_getThreadService()->fetchThread($tids);
		parent::__construct();
		$this->service = new PwDeleteTopic(new PwFetchTopicByTid($tids), $this->user);
		$this->threadsInfo = $this->service->getData();
	}
	
	public function check() {
		if (!$this->_checkPermission()) {
			return new PwError('BBS:manage.permission.deny');
		}
		return true;
	}
	
	public function execute() {
		$result = $this->check();
		if ($result instanceof PwError) {
			return $result;
		}
		$this->service->setRecycle(true)->setIsDeductCredit(true)->execute();
		//$this->deleteThread();
		//$this->deleteReplies();
		return true;
	}
	
	public function deleteThread(){
		if ($this->recycle) {
			foreach ($this->threadsInfo as $threadInfo) {
				$topicDm = new PwTopicDm($threadInfo['tid']);
				$topicDm->setFid(0);
				$this->_getThreadService()->updateThread($topicDm);
			}
		} else {
			foreach ($this->threadsInfo as $threadInfo) {
				$this->_getThreadService()->deleteThread($threadInfo['tid']);
			}
		}
	}
	
	public function deleteReplies(){
		$replyService = $this->_getReplyService();
		if ($this->recycle) {
			$replyService->updateReplies();
		} else {
			$replyService->deleteReplies();
		}
	}
	
	protected function _deleteCredits(){
		
	}
	
	protected function _deleteAttaches(){
		
	}
	
	protected function _addRecycle(){
		
	}
	
	public function getDefaultValue(){
		//not need
	}
	
	/**
	 * 
	 * @return PwThread
	 *
	 */
	protected function _getThreadService(){
		return Wekit::load('forum.PwThread');
	}
		
	protected function _getReplyService(){
		return Wekit::load('forum.PwPosts');
	}
}