<?php
/**
 * Enter description here ...
 * 
 * @author peihong.zhangph <peihong.zhangph@aliyun-inc.com> Dec 19, 2011
 * @link http://www.phpwind.com
 * @copyright 2011 phpwind.com
 * @license
 * @version $Id: PwManageDigest.php 0 Dec 19, 2011 10:03:16 AM peihong.zhangph $
 */

Wind::import('SRV:forum.srv.manage.PwManageAction');
Wind::import('SRV:forum.dm.PwTopicDm');

class PwManageDigest extends PwManageAction {
	
	public $threadsInfo;
	protected $digest = 0;
	
	public function __construct($tids, $user = null) {
		parent::__construct();
		$this->threadsInfo = $this->_getThreadService()->fetchThread($tids);
		//$this->user = $user ? $user : PwUserBo::getLoginUser();
	}
	
	public function setDigest($digest = 1){
		$digest = intval($digest);
		$this->digest = $digest;
	}
	
	public function check() {
		if (!$this->_checkPermission()) {
			return new PwError('BBS:manage.permission.deny');
		}
		
		if ($this->nextAction) {
			return $this->nextAction->check();
		}
		return true;
	}
	
	public function execute() {
		$this->updateThreads();
		if ($this->nextAction) {
			return $this->nextAction->execute();
		}
		return true;
	}
	
	/**
	 * (non-PHPdoc)
	 * @see srv/manage/PwManageAction::getDefaultValue()
	 * @return array
	 */
	public function getDefaultValue(){
		$defaultValue = array();
		$threadInfo = current($this->threadsInfo);
		$defaultValue['digest']['digest'] = $threadInfo['digest'];
		
		if ($this->nextAction) {
			return array_merge($defaultValue,$this->nextAction->getDefaultValue());
		} else {
			return $defaultValue;
		}
	}
	
	public function updateThreads(){
		foreach ($this->threadsInfo as $threadInfo) {
			$topicDm = new PwTopicDm($threadInfo['tid']);
			$topicDm->setDigest($this->digest);
			$this->_getThreadService()->updateThread($topicDm);
		}
	}
}