<?php
/**
 * Enter description here ...
 * 
 * @author peihong.zhangph <peihong.zhangph@aliyun-inc.com> Dec 19, 2011
 * @link http://www.phpwind.com
 * @copyright 2011 phpwind.com
 * @license
 * @version $Id: PwManageDown.php 0 Dec 19, 2011 10:04:41 AM peihong.zhangph $
 */

Wind::import('SRV:forum.srv.manage.PwManageAction');
Wind::import('SRV:forum.dm.PwTopicDm');

class PwManageDown extends PwManageAction {
	
	public $threadsInfo;
	protected $downtime = 0;
	protected $push;
	
	
	public function __construct($tids, $user = null) {
		parent::__construct();
		$this->threadsInfo = $this->_getThreadService()->fetchThread($tids);
	}
	
	public function setDowntime($downtime){
		$downtime = intval($downtime);
		if ($downtime > 0) {
			$this->downtime = $downtime * 3600;
		}
	}
	
	
	public function setPush($push){
		if (!is_numeric($push)) return false;
		$this->push = intval($push);
	}
	
	public function check() {
		if (!$this->_checkPermission()) {
			return new PwError('BBS:manage.permission.deny');
		}
		if ($this->nextAction) {
			return $this->nextAction->check();
		}
		return true;
	}
	
	public function execute() {
		$result = $this->check();
		if ($result instanceof PwError) {
			return $result;
		}
		$this->updateThreads();
		
		if ($this->nextAction) {
			return $this->nextAction->execute();
		}
		return true;
	}
	
	public function updateThreads(){
		foreach ($this->threadsInfo as $threadInfo) {
			$topicDm = new PwTopicDm($threadInfo['tid']);
			if ($this->downtime > 0){
				$topicDm->setLastposttime(max($threadInfo['lastpost_time'] - $this->downtime,0));
			} else {
				$topicDm->setLastposttime(0);
			}
			if ($this->push) {
				$locked = $threadInfo['locked'] % 3 + 3;
				$topicDm->setLocked($locked);
			} else if ($this->push === 0){
				$locked = $threadInfo['locked'] % 3;
				$topicDm->setLocked($locked);
			}
			$this->_getThreadService()->updateThread($topicDm);
		}
	}
	
	/**
	 * 
	 * no default value for this management
	 * 
	 * @see srv/manage/PwManageAction::getDefaultValue()
	 * @return array
	 */
	public function getDefaultValue(){
		$defaultValue = array();
		if ($this->nextAction) {
			return $this->nextAction->getDefaultValue();
		} else {
			return $defaultValue;
		}
	}	
	
	protected function _getThreadService(){
		return Wekit::load('forum.PwThread');
	}
	
}