<?php
/**
 * Enter description here ...
 * 
 * @author peihong.zhangph <peihong.zhangph@aliyun-inc.com> Dec 19, 2011
 * @link http://www.phpwind.com
 * @copyright 2011 phpwind.com
 * @license
 * @version $Id: PwManageHighlight.php 0 Dec 19, 2011 10:05:46 AM peihong.zhangph $
 */

Wind::import('SRV:forum.srv.manage.PwManageAction');
Wind::import('SRV:forum.dm.PwTopicDm');

class PwManageHighlight extends PwManageAction {
	
	public $threadsInfo;
	
	protected $hightlight;
	protected $overtime = 0;
	
	public function __construct($tids, $user = null) {
		parent::__construct();
		$this->threadsInfo = $this->_getThreadService()->fetchThread($tids);
	}
	
	public function check() {
		if (!$this->_checkPermission()) {
			return new PwError('BBS:manage.permission.deny');
		}
		if ($this->nextAction) {
			return $this->nextAction->check();
		}
		return true;
	}
	
	public function setHighlight($hightlight){
		$this->hightlight = $hightlight;
	}
	
	public function setOvertime($overtime){
		if (!is_numeric($overtime)) {
			$overtime = Pw::str2time($overtime) + 86399;
		}
		$this->overtime = intval($overtime);
	}
	
	public function execute() {
		$this->updateThreads();
		if ($this->nextAction) {
			return $this->nextAction->execute();
		}
		return true;
	}
	
	/**
	 * (non-PHPdoc)
	 * @see srv/manage/PwManageAction::getDefaultValue()
	 * @return array
	 */
	public function getDefaultValue(){
		$defaultValue = array();
		reset($this->threadsInfo);
		$threadInfo = current($this->threadsInfo);
		Wind::import("Lib:utility.Pwhighlight");
		$hightlight = new PwHighlight();
		$defaultValue['highlight'] = $hightlight->parseHighlight($threadInfo['highlight']);
		//过期时间
		$overtime = $this->_getOvertimeDs()->getOvertimeByTidAndType($threadInfo['tid'],'highlight');
		$overtime && $defaultValue['highlight']['overtime'] = $overtime['overtime'];
		if ($this->nextAction) {
			return array_merge($defaultValue,$this->nextAction->getDefaultValue());
		} else {
			return $defaultValue;
		}
	}
	
	public function updateThreads(){
		foreach ($this->threadsInfo as $threadInfo) {
			$tid = $threadInfo['tid'];
			$topicDm = new PwTopicDm($tid);
			$topicDm->setHighlight($this->hightlight);
			$this->_getOvertimeDs()->setOvertime($tid,'highlight',$this->overtime);
			if (!$threadInfo['overtime'] && $this->overtime || $threadInfo['overtime'] > $this->overtime) {
				$topicDm->setOvertime($this->overtime);
			} else {
				$overtimes = $this->_getOvertimeDs()->getOvertimeByTid($tid);
				$threadOvertime = $this->overtime;
				foreach ($overtimes as $v) {
					if ($v['overtime'] < $threadOvertime) {
						$threadOvertime = $v['overtime'];
					}
				}
				$topicDm->setOvertime($threadOvertime);
			}
			$this->_getThreadService()->updateThread($topicDm);
		}
		return true;
	}
	
	/**
	 * 
	 * Enter description here ...
	 * @return PwOvertime
	 */
	protected function _getOvertimeDs(){
		return Wekit::load('forum.PwOvertime');
	}
}