<?php
/**
 * Enter description here ...
 * 
 * @author peihong.zhangph <peihong.zhangph@aliyun-inc.com> Dec 19, 2011
 * @link http://www.phpwind.com
 * @copyright 2011 phpwind.com
 * @license
 * @version $Id: PwManageLock.php 0 Dec 19, 2011 10:03:43 AM peihong.zhangph $
 */

Wind::import('SRV:forum.srv.manage.PwManageAction');
Wind::import('SRV:forum.dm.PwTopicDm');

class PwManageLock extends PwManageAction {
	
	public $threadsInfo;
	protected $locked = 0;
	
	public function __construct($tids, $user = null) {
		parent::__construct();
		$this->threadsInfo = $this->_getThreadService()->fetchThread($tids);
	}
	
	public function setLocked($locked = 1){
		$locked = intval($locked);
		$this->locked = $locked;
	}
	
	public function check() {
		if (!$this->_checkPermission()) {
			return new PwError('BBS:manage.permission.deny');
		}
		if ($this->nextAction) {
			return $this->nextAction->check();
		}
		return true;
	}
	
	public function execute() {
		$result = $this->check();
		if ($result instanceof PwError) {
			return $result;
		}
		$this->updateThreads();
		
		if ($this->nextAction) {
			return $this->nextAction->execute();
		}
		return true;
	}
	
	/**
	 * (non-PHPdoc)
	 * @see srv/manage/PwManageAction::getDefaultValue()
	 * @return array
	 */
	public function getDefaultValue(){
		$defaultValue = array();
		$threadInfo = current($this->threadsInfo);
		$defaultValue['lock']['locked'] = $threadInfo['locked'] % 3;
		
		if ($this->nextAction) {
			return array_merge($defaultValue,$this->nextAction->getDefaultValue());
		} else {
			return $defaultValue;
		}
	}
	
	public function updateThreads(){
		foreach ($this->threadsInfo as $threadInfo) {
			$topicDm = new PwTopicDm($threadInfo['tid']);
			$topicDm->setLocked($this->locked);
			$this->_getThreadService()->updateThread($topicDm);
		}
	}
	
}