<?php
/**
 * Enter description here ...
 * 
 * @author peihong.zhangph <peihong.zhangph@aliyun-inc.com> Dec 13, 2011
 * @link http://www.phpwind.com
 * @copyright 2011 phpwind.com
 * @license
 * @version $Id: PwManageTopped.php 17002 2012-08-30 07:49:23Z peihong.zhangph $
 */

Wind::import('SRV:forum.srv.manage.PwManageAction');
Wind::import('SRV:forum.dm.PwTopicDm');
Wind::import('SRV:forum.dm.PwSpecialSortDm');

class PwManageTopped extends PwManageAction {
	
	protected $topped = 0;
	protected $specialsort = 0;
	protected $overtime = 0;
	protected $fids = array();
	private $_forumset;
	
	public function __construct($tids, $user = null) {
		parent::__construct();
		$this->threadsInfo = $this->_getThreadService()->fetchThread($tids);
		$this->_getForum();
	}

	public function setTopped($topped) {
		$topped = intval($topped);
		if ($topped < 1 || $topped > 3) return false;
		$this->topped = $topped; 
	}
	
	public function setForums($fids){
		$toppedType = $this->getToppedType();
		if ($toppedType < 3) {
			//TODO
		}
		$this->fids = $fids;
	}
	
	public function setOvertime($overtime) {
		if (is_numeric($overtime)) {
			$this->overtime = $overtime;
		} else {
			$this->overtime = Pw::str2time($overtime) + 86399;
		}
	}
	
	public function check(){
		if (!$this->_checkPermission()) {
			return new PwError('BBS:manage.permission.deny');
		} else if (true !== ($rs = $this->checkToppedPermission())) {
			return $rs;
		}
		//next action check
		if ($this->nextAction) {
			return $this->nextAction->check();
		}
		return true;
	}

	private function checkToppedPermission(){
		$permission = $this->_permissions;
		if ($this->topped > $permission['topped_type'] || !$permission['topped_type']) {
			return new PwError('BBS:manage.permission.deny');
		}
		foreach ($this->threadsInfo as $v) {
			if ($v['topped'] > $permission['topped_type']) {
				return new PwError('BBS:manage.permission.deny');
			}
		}
		return true;
	}
	
	public function getToppedType(){
		return $this->_permissions['topped_type'];
	}
	
	public function execute() {
		$this->_initTopped();
		$this->updateThreads();
		$this->updateTopped();
		if ($this->nextAction) {
			return $this->nextAction->execute();
		}
		return true;
	}
	
	private function _initTopped(){
		if ($this->topped == 1) {
			$this->fids = array($this->_forumset['fid']);
		} else if ($this->topped == 2) {
			$this->fids = $this->_getForums($this->fids);
		} else if ($this->topped == 3) {
			$this->fids = $this->_getForums();
		} else {
			$this->fids = array();
		}
	}
	
	private function _getForums($fids = array()){
		if ($fids) {
			$forums = $this->_getForumDS()->fetchForum($fids);
		} else {
			$forums = $this->_getForumDS()->getForumList();
		}
		return $this->_filterForums($forums);
	}
	
	private function _filterForums($forums){
		$fids = array();
		foreach ($forums as $k=>$v) {
			if ($v['type'] == 'category') {
				continue;
			}
			$fids[] = $v['fid'];
		}
		return $fids;
	}
	
	/**
	 * 
	 * 更新帖子信息
	 *
	 */
	public function updateThreads(){
		$specialSort = $this->_getSpecialSort($this->topped);
		foreach ($this->threadsInfo as $threadInfo) {
			$tid = $threadInfo['tid'];
			$topicDm = new PwTopicDm($tid);
			$topicDm->setTopped($this->topped);
			$topicDm->setSpecialsort($specialSort);
			//overtime
			$this->_getOvertimeDs()->setOvertime($tid, 'topped', $this->overtime);
			if (!$threadInfo['overtime'] && $this->overtime || $threadInfo['overtime'] > $this->overtime) {
				$topicDm->setOvertime($this->overtime);
			} else {
				$overtimes = $this->_getOvertimeDs()->getOvertimeByTid($tid);
				$threadOvertime = $this->overtime;
				foreach ($overtimes as $v) {
					if ($v['overtime'] < $threadOvertime) {
						$threadOvertime = $v['overtime'];
					}
				}
				$topicDm->setOvertime($threadOvertime);
			}
			$this->_getThreadService()->updateThread($topicDm);
		}
	}
	
	/**
	 * 
	 * 更新置顶信息
	 *
	 */
	public function updateTopped(){
		$toppedService = $this->_getSpecialSortDs();
		foreach ($this->threadsInfo as $threadInfo) {
			$tid = $threadInfo['tid'];
			$toppedService->deleteSpecialSortByTid('topped',$tid);
			foreach ($this->fids as $fid) {
				$dm = new PwSpecialSortDm();
				$dm->setFid($fid);
				$dm->setTid($tid);
				$dm->setType('topped');
				$dm->setExtra($this->topped);
				$dm->setEndtime($this->overtime);
				$toppedService->addSpecialSort($dm);
			}
		}
		return true;
	}
	
	/**
	 * (non-PHPdoc)
	 * @see srv/manage/PwManageAction::getDefaultValue()
	 */
	public function getDefaultValue(){
		$defaultValue = array();
		reset($this->threadsInfo);
		$threadInfo = current($this->threadsInfo);
		$toppedInfo = $this->_getSpecialSortDs()->getSpecialSortByTid('topped',$threadInfo['tid']);
		if ($toppedInfo) {
			//topped
			$defaultValue['topped']['topped'] = $threadInfo['topped'];
			//fids
			$fids = array();
			if ($threadInfo['topped'] > 1) {
				foreach ($toppedInfo as $v) {
					$fids[] = $v['fid'];
				}
			} else {
				$fids = array($threadInfo['fid']);
			}
			$defaultValue['topped']['fids'] = $fids;
			//end time
			reset($toppedInfo);
			$v = current($toppedInfo);
			$defaultValue['topped']['overtime'] = $v['end_time'];
		}

		if ($this->nextAction) {
			return array_merge($defaultValue,$this->nextAction->getDefaultValue());
		} else {
			return $defaultValue;
		}
	}
	
	public function getForumList($groupid,$currentCategory=false){
		return $this->_getToppedService()->getForumListForHeadTopic($groupid,$this->_forumset['fid'],$currentCategory);
	}
	
	public function beforeRun() {
		foreach ($this->_do as $do) {
		}
	}
	
	public function afterRun() {
		foreach ($this->_do as $do) {
		}
	}
	
	private function _getSpecialSort($topped){
		$specialSort = 0;
		if ($topped > 0) {
			$const = "SPECIAL_SORT_TOP$topped";
			eval("\$specialSort = PwThread::$const;");
		}
		return $specialSort;
	}
	
	private function _getForum(){
		$fid = 0;
		foreach ($this->threadsInfo as $v) {
			if ($fid && $v['fid'] != $fid) return new PwError('MANAGE.multiple_forums_typed');
			$fid = $v['fid'];
		}
		if (!$fid) return true;
		$forum = $this->_getForumDS()->getForum($fid,PwForum::FETCH_EXTRA);
		$forumset = unserialize($forum['settings_basic']);
		$forumset['fid'] = $fid;
		$this->_forumset = $forumset;
	}
	
	/**
	 * 
	 * Enter description here ...
	 * @return PwOvertime
	 */
	protected function _getOvertimeDs(){
		return Wekit::load('forum.PwOvertime');
	}
	
	/**
	 * 
	 * Enter description here ...
	 * @return PwSpecialSort
	 */
	protected function _getSpecialSortDs(){
		return Wekit::load('forum.PwSpecialSort');
	}
	
	/**
	 * 
	 * Enter description here ...
	 * @return PwForum
	 */
	private function _getForumDS(){
		return Wekit::load('forum.PwForum');
	}
		
	/**
	 * 
	 * Enter description here ...
	 * @return PwToppedService
	 */
	protected function _getToppedService(){
		return Wekit::load('forum.srv.PwToppedService');
	}
}