<?php

Wind::import('SRV:forum.srv.manage.PwManageAction');
Wind::import('SRV:forum.dm.PwTopicDm');

class PwManageType extends PwManageAction {
	
	protected $target_topic_type = 0;
	private $_forumset = array();
	
	public function __construct($tids, $user = null) {
		parent::__construct();
		$this->threadsInfo = $this->_getThreadService()->fetchThread($tids);
		$this->_getForum();
	}
	
	public function setTargetTopictype($topicType){
		$this->target_topic_type = intval($topicType);
	}
	
	public function check() {
		if (!$this->_checkPermission()) {
			return new PwError('BBS:manage.permission.deny');
		}
		return $this->checkTopicType();
	}
	
	public function execute() {
		if (true !== ($result = $this->checkTopicType(true))){
			return $result;
		}
		$this->updateThreads();
		if ($this->nextAction) {
			return $this->nextAction->execute();
		}
		return true;
	}
	
	private function _getForum(){
		$fid = 0;
		foreach ($this->threadsInfo as $v) {
			if ($fid && $v['fid'] != $fid) return new PwError('MANAGE.multiple_forums_typed');
			$fid = $v['fid'];
		}
		if (!$fid) return true;
		$forum = $this->_getForumDS()->getForum($fid,PwForum::FETCH_EXTRA);
		$forumset = unserialize($forum['settings_basic']);
		$forumset['fid'] = $fid;
		$this->_forumset = $forumset;
	}
	
	private function checkTopicType($submit = false){
		if (!$this->_forumset['topic_type']){
			return new PwError('MANAGE.topictype_closed');
		} else {
			$topicTypes = $this->getTopicTypes();
			if (!$topicTypes['all_types']) return new PwError('MANAGE.topictype_closed');
			if (!$submit) return true;
				
			if ($this->_forumset['force_topic_type'] && !$this->target_topic_type) {
				return new PwError('MANAGE.topictype_force');
			} elseif (!$topicTypes['all_types'][$this->target_topic_type]) {
				return new PwError('MANAGE.target_topictype_error');
			}
			return true;
		}
	}

	public function getTopicTypes(){
		return $this->_getTopicTypeDS()->getTopicTypesByFid($this->_forumset['fid']);
	}
	
	/**
	 * (non-PHPdoc)
	 * @see srv/manage/PwManageAction::getDefaultValue()
	 */
	public function getDefaultValue(){
		
	}
	
	public function updateThreads(){
		foreach ($this->threadsInfo as $threadInfo) {
			$topicDm = new PwTopicDm($threadInfo['tid']);
			$topicDm->setTopictype($this->target_topic_type);
			$this->_getThreadService()->updateThread($topicDm);
		}
		return true;
	}
	
	/**
	 * 
	 * Enter description here ...
	 * @return PwForum
	 */
	private function _getForumDS(){
		return Wekit::load('forum.PwForum');
	}
	
	/**
	 * 
	 * Enter description here ...
	 * @return PwTopicType
	 */
	private function _getTopicTypeDS(){
		return Wekit::load('forum.PwTopicType');
	}
}