<?php
/**
 * Enter description here ...
 * 
 * @author peihong.zhangph <peihong.zhangph@aliyun-inc.com> Dec 19, 2011
 * @link http://www.phpwind.com
 * @copyright 2011 phpwind.com
 * @license
 * @version $Id: PwManageUp.php 0 Dec 19, 2011 10:04:52 AM peihong.zhangph $
 */

Wind::import('SRV:forum.srv.manage.PwManageAction');
Wind::import('SRV:forum.dm.PwTopicDm');

class PwManageUp extends PwManageAction {
	
	public $threadsInfo;
	protected $uptime;
	
	public function __construct($tids, $user = null) {
		parent::__construct();
		$this->threadsInfo = $this->_getThreadService()->fetchThread($tids);
	}
	
	public function setUptime($uptime){
		if ($uptime < 1) {
			$this->uptime = Pw::getTime();
		} else {
			$this->uptime = $uptime * 3600;
		}
		return true;
	}
	
	public function check() {
		if (!$this->_checkPermission()) {
			return new PwError('BBS:manage.permission.deny');
		}
		
		if ($this->nextAction) {
			return $this->nextAction->check();
		}
		return true;
	}
	
	public function execute() {
		$this->updateThreads();
		if ($this->nextAction) {
			return $this->nextAction->execute();
		}
		return true;
	}
	
	/**
	 * 
	 * no default value for this management
	 * 
	 * @see srv/manage/PwManageAction::getDefaultValue()
	 * @return array
	 */
	public function getDefaultValue(){
		$defaultValue = array();
		
		if ($this->nextAction) {
			return $this->nextAction->getDefaultValue();
		} else {
			return $defaultValue;
		}
	}
	
	public function updateThreads(){
		foreach ($this->threadsInfo as $threadInfo) {
			$topicDm = new PwTopicDm($threadInfo['tid']);
			$topicDm->setLastposttime($threadInfo['lastpost_time'] + $this->uptime);
			$this->_getThreadService()->updateThread($topicDm);
		}
	}
	
}