<?php

Wind::import('SRV:forum.srv.manage.PwThreadManageDo');
Wind::import('SRV:forum.dm.PwTopicDm');

/**
 * 帖子管理 - 移动
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package wind
 */
class PwThreadManageDoMove extends PwThreadManageDo {
	
	public $fid;
	public $topictype;
	public $forum;

	protected $tids;
	
	public function __construct(PwThreadManage $srv){
		parent::__construct($srv);
	}
	
	public function check($permission) {
		if (!isset($permission['move']) || !$permission['move']) {
			return false;
		} else if (isset($this->fid)) {
			Wind::import('SRV:forum.bo.PwForumBo');
			$this->forum = new PwForumBo($this->fid);
			if (!$this->forum->isForum()) {
				return new PwError('BBS:manage.error.move.targetforum');
			}
		}
		return true;
	}

	public function gleanData($value) {
		$this->tids[] = $value['tid'];
	}
	
	/**
	 * 设置需要复制到的版块
	 *
	 * @param int $fid
	 * @return int
	 */
	public function setFid($fid) {
		$this->fid = intval($fid);
		return $this;
	}
	
	/**
	 * 设置主题分类
	 *
	 * @param int $topictype
	 * @return int
	 */
	public function setTopictype($topictype) {
		$this->topictype = intval($topictype);
		return $this;
	}
	
	/**
	 * 复制帖子 | 复制特殊帖、附件等待做。。。
	 *
	 * @param int $topictype
	 * @return int
	 */
	public function run() {
		$topicDm = new PwTopicDm(true);
		$topicDm->setTopictype($this->topictype)
				->setFid($this->fid);
		$this->_getThreadDs()->batchUpdateThread($this->tids, $topicDm, PwThread::FETCH_MAIN);

		if (!$this->forum->isOpen()) {
			Wekit::load('attention.PwFresh')->batchDeleteByType(PwFresh::TYPE_THREAD_TOPIC, $this->tids);

			//回复与新鲜事的关联
			if ($data = Wekit::load('attention.PwFreshIndex')->fetchByTid($this->tids)) {
				Wekit::load('attention.PwFresh')->batchDelete(array_keys($data));
			}
		}
	}
	
	/**
	 * Enter description here ...
	 *
	 * @return PwThread
	 */
	public function _getThreadDs() {
		return Wekit::load('forum.PwThread');
	}
}