<?php

Wind::import('SRV:forum.srv.manage.PwThreadManageDo');

/**
 * 帖子发布流程
 *
 * -> 1.check 检查帖子发布运行环境
 * -> 2.appendDo(*) 增加帖子发布时的行为动作,例:投票、附件等(可选)
 * -> 3.execute 发布
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwThreadManageDoShield.php 14354 2012-07-19 10:36:06Z jieyin $
 * @package forum
 */

class PwThreadManageDoShield extends PwThreadManageDo {
	
	protected $tids;
	protected $pids;
	protected $reason;
	protected $ifShield;

	public function check($permission) {
		return (isset($permission['shield']) && $permission['shield']) ? true : false;
	}

	public function gleanData($value) {
		if ($value['pid']) {
			$this->pids[] = $value['pid'];
		} else {
			$this->tids[] = $value['tid'];
		}
	}
	
	public function run() {
		if ($this->pids) {
			Wind::import('SRV:forum.dm.PwReplyDm');
			$topicDm = new PwReplyDm(true);
			$topicDm->setIfshield($this->ifShield);
			$this->_getThreadDs()->batchUpdatePost($this->pids, $topicDm);
		}
		if ($this->tids) {
			Wind::import('SRV:forum.dm.PwTopicDm');
			$topicDm = new PwTopicDm(true);
			$topicDm->setIfshield($this->ifShield);
			$this->_getThreadDs()->batchUpdateThread($this->tids, $topicDm, PwThread::FETCH_MAIN);
		}
	}

	public function setIfShield($ifShield) {
		$this->ifShield = intval($ifShield);
		return $this;
	}
	
	public function setReason($reason) {
		$this->reason = $reason;
		return $this;
	}
	
	/**
	 * Enter description here ...
	 *
	 * @return PwThread
	 */
	public function _getThreadDs() {
		return Wekit::load('forum.PwThread');
	}
	
}