<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('SRV:forum.srv.post.do.PwPostDoBase');
Wind::import('SRV:tag.dm.PwTagDm');
/**
 * 帖子发布 - 话题
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package wind
 */
class PwPostDoTag extends PwPostDoBase {

	private $loginUser;
	private $defaultType = 'threads';
	private $tagNames = array();
	
	public function __construct(PwPost $pwpost,$tagNames) {
		$this->loginUser = $pwpost->user;
		$this->tagNames = $tagNames;
	}

	public function addThread($tid) {
		$this->addTags($tid);
	}
	
	public function updateThread($tid) {
		$this->addTags($tid);
	}
	
	public function getDm() {
		return new PwTagDm();
	}
	
	private function addTags($tid) {
		$typeId = $this->_getService()->getTypeIdByTypeName($this->defaultType);
		$dmArray = array();
		foreach ($this->tagNames as $value) {
			$value = trim($value);
			$dm = $this->getDm();
			$dmArray[$value] = 
				$dm->setName($value)
					->setTypeId($typeId)
					->setParamId($tid)
					->setIfhot(1)
					->setCreateUid($this->loginUser->uid)
			;
		}
		$this->_getService()->updateTags($typeId,$tid,$dmArray);
		$tags = $this->_getService()->getTagByType($this->defaultType,$tid);
		if ($tags) {
			Wind::import('SRV:forum.dm.PwTopicDm');
			$dm = new PwTopicDm($tid);
			$dm->setTags($this->_formatTags($tags));
			Wekit::load('forum.PwThread')->updateThread($dm,PwThread::FETCH_CONTENT);
		}
	}
	
	public function check() {
		$count = count($this->tagNames);
		if ($count == 1) {
			$this->getDm()->setName($this->tagNames['0']);
			if(($return = $this->getDm()->beforeAdd()) instanceof PwError) return $return;
		}
		if ($count > 5) {
			return new PwError("Tag:tagnum.exceed");
		}
		if ($count && $this->loginUser->getPermission('tag_allow_add') < 1) {
			return new PwError("TAG:right.tag_allow_add.error");
		}
		return true;
	}
	
	/**
	 * 格式化用户数组
	 * 
	 * @param array $users array('uid' => username)
	 * @return string uid,username,uid,username....
	 */
	protected function _formatTags($tags) {
		if (!$tags) return false;
		$tag = '';
		foreach ($tags as $v) {
			$tag .= $v['tag_id'] . ',' . $v['tag_name'] . ',';
		}
		return rtrim($tag,',');
	}
	
	/**
	 * Enter description here ...
	 *
	 * @return PwTagService
	 */
	protected function _getService() {
		return Wekit::load('tag.srv.PwTagService');
	}
}