<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('LIB:ubb.PwUbbCode');

/**
 * 帖子附件附件展示 / ubb解析
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwAttachDisplay.php 18218 2012-09-11 14:41:52Z hao.lin $
 * @package forum|attach
 */

class PwAttachDisplay {
	
	public $attachs;
	public $showlist = array();
	public $user;

	protected $isAdmin;
	protected $downloadUrl = 'bbs/attach/download?';

	public function __construct($tid, $pids, PwUserBo $user) {
		$this->user = $user;
		$this->attachs = $this->_getData($tid, $pids);
		$this->isAdmin = $user->getPermission('operate_thread.deleteatt');
		$this->_init();
	}

	public function has($id) {
		return isset($this->attachs[$id]);
	}
	
	public function getList($id) {
		return $this->showlist[$id];
	}

	public function getHtml($pid, $aid) {
		if (!isset($this->attachs[$pid]) || !isset($this->attachs[$pid][$aid])) {
			return '';
		}
		$att = $this->attachs[$pid][$aid];
		$atype = $att['atype'];
		unset($this->showlist[$pid][$atype][$aid]);
		return $this->bulidHtml($atype, $att);
	}

	public function bulidHtml($atype, $att) {
		$html = '';
		switch ($atype) {
			case 'pic':
				$html = $this->parsePicHtml($att);
				break;
			case 'downattach':
				$html = $this->parseAttachHtml($att);
				break;
			case 'picurl':
				$html = "&#36828;&#31243;&#22270;&#29255;：<a href=\"job.php?action=showimg&tid={$GLOBALS[tid]}&pid={$GLOBALS[tpc_pid]}&fid={$GLOBALS[fid]}&aid={$att[aid]}&verify={$att[verify]}\" target=\"_blank\">$att[name]</a>";
				break;
		}
		return "<span id=\"att_{$att['aid']}\">" . $html . '</span>';
	}

	public function parsePicHtml($att) {
		$html  = "<span id=\"td_att_{$att['aid']}\" class=\"J_attach_img_wrap single_img\">";
		$html .= '<div class="img_info J_img_info">';
		if ($att['descrip']) {
			$html .= '<p>描述：' . $att['descrip'] . '</p>';
		}
		$html .= '<p>图片：' . $att['name'];
		if ($this->isAdmin) {
			$html .= '<a class="J_read_img_del" href="' . WindUrlHelper::createUrl('bbs/attach/delete?aid=' . $att['aid']) . '">[删除]</a>';
		}
		$html .= '</p></div>';
		$html .= $att['img'];
		$html .= '</span>';
		/*
		$html .= "<div id=\"menu_att{$att[aid]}\" class=\"fl\" style=\"display:none;\"><div class=\"pw_menu\" style=\"position:absolute;z-index:1;\"><div style=\"border:1px solid $forumcolorone;background:$forumcolortwo;padding:5px 10px;\">";
		$att['descrip'] && $html .= "<p>描述:$att[descrip]</p>";
		$html .= "<p><span class=\"mr10\">图片:$att[name]</span>";
		if($att['dfadmin']) {
			$setCoverHtml = ($isTucool && ($read['authorid'] == $authorid || $isGM)) ? sprintf('[<a class="cp s4" onclick="setcover(\'%s\',this);">设为封面</a>] ',$att['aid']) : '';
			$html .= "{$setCoverHtml}[<a class=\"cp s4\" onclick=\"delatt('','$att[aid]','{$this->mode}');\">删除</a>]";
		}
		$html .= "</p></div></div></div>";
		*/
		return $html;
	}
	
	public function parseAttachHtml($att) {
		$lang = array(0 => '', 1 => '');
		if ($att['cost'] > 0) {
			$creditBo = PwCreditBo::getInstance();
			$lang[0] = $att['special'] == 1 ? '加密：' : '出售：';
			$lang[1] = '需要&nbsp;<span class="org">' . $att['cost'] . '</span>&nbsp;' . $creditBo->cType[$att['ctype']] . '&nbsp;';
			$lang[2] = $att['special'] == 2 ? ' J_qlogin_trigger' : '';
			
			if ($att['special'] == 1) {
				$lang[1] .= '<span class="tips_icon_' . ($this->user->getCredit($att['ctype']) > $att['cost'] ? 'success' : 'error') . '"><span>&nbsp;</span>';
			}
		}
		$html = '<span class="file_insert"><span class="file_list_wrap"><span class="file_icon_' . $att['ext'] . '"></span></span>' . $lang[0] . '<a href="' . WindUrlHelper::createUrl($this->downloadUrl . 'aid=' . $att['aid']) . '" class="mr5 J_post_buy' . $lang[2] . '" data-price="' . $att['cost'] . '" data-type="' . $att['special'] . '" data-util="' . $creditBo->cType[$att['ctype']] . '" data-credit="' . $this->user->getCredit($att['ctype']) . '" data-role="attach">' . $att['name'] . '</a>' . $lang[1] . '</span><div class="img_info J_img_info" style="display: none;"><p>图片：A74.jpg<a href="" class="J_read_img_del">[删除]</a></p></div>';

		//$html = '<b>' . $att['descrip'] . '</b>' . "<a class=\"file_icon_rar\" href=\"" . WindUrlHelper::createUrl($this->downloadUrl . 'aid=' . $att['aid']) . "\"> {$att['name']}</a> ({$att['size']} K) &#19979;&#36733;&#27425;&#25968;:{$att['hits']} ";
		/*
		if ($att['needrvrc'] > 0) {
			$tmpLang = array(
				'title' => array(1 => '', 2 => '<span class="b s2">&#38468;&#20214;&#20986;&#21806;：</span>'),
				'type' => array(1 => '&#21152;&#23494;', 2 => '&#20986;&#21806;'),
				'need' => array(1 => '&#38656;&#35201;', 2 => '&#21806;&#20215;'),
				'record' => array(1 => '', 2 => "<a class=\"mr10 s4\" title=\"&#26597;&#30475;&#35760;&#24405;\" onclick=\"sendmsg('job.php?action=attachbuy&amp;type=record&amp;aid={$att['aid']}');\" href=\"javascript:;\">[&#35760;&#24405;]</a>")
			);
			$type = $att['special'] == 2 ? 2 : 1;
			$html = $tmpLang['title'][$type] . "<span class=\"w\"><img src=\"$GLOBALS[imgpath]/$GLOBALS[stylepath]/file/$att[type].gif\" align=\"absmiddle\" /><a id=\"td_att{$att['aid']}\" href=\"{$this->downloadUrl}aid=$att[aid]\" onclick=\"return ajaxurl(this,'&check=1');\" onmouseover=\"read.open('menu_att{$att['aid']}','td_att{$att['aid']}');\" style=\"margin-left:5px;margin-right:10px;\">$att[name]</a></span>";
			$att['type'] == 'img' && $this->viewHiddenAtt($att) && $html.= '<br>'.$att['img'].'<br>';
			$html .= "<div id=\"menu_att{$att['aid']}\" class=\"pw_menu\" style=\"display:none;position:absolute\"><div class=\"p10\"><ul>".
				"<li>&#31867;&#22411;: <span class=\"b s2\">{$tmpLang['type'][$type]}</span></li>".
				"<li>&#19979;&#36733;: $att[hits]</li>".
				"<li>{$tmpLang['need'][$type]}: {$att[needrvrc]}{$att[cname]}</li>".
				"<li>&#22823;&#23567;: $att[size] K</li>";
			$att['descrip'] && $html .= "<li>&#25551;&#36848;: {$att['descrip']}</li>";
			$html .= "<li>{$tmpLang['record'][$type]}<span onclick=\"return ajaxurl(getObj('td_att{$att['aid']}'),'&check=1');\" class=\"mr10 s4 cp\" id=\"fg_{$att['aid']}\">[&#19979;&#36733;]</span>";
			$att['dfadmin'] && $html .= "<a onclick=\"delatt('tpc','{$att['aid']}','{$this->mode}');\" class=\"cp s4\">[&#21024;&#38500;]</a>";
			$html .= "</li></ul></div></div>";
		} elseif (in_array($att['ext'], array('mp3','wma','wmv','rm','swf'))) {
			$html .= "[<a style=\"cursor:pointer\" onclick=\"playatt('$att[aid]');\">&#35797;&#25773;</a>]";
		}
		*/
		return $html;
	}

	public function analyse($attach) {
		if ($attach['type'] == 'img' && $attach['cost'] == 0) {
			$atype = 'pic';
			$url = Pw::getPath($attach['path']);
			$attach += array(
				'url' => $url,
				'img' => PwUbbCode::createImg(Pw::getPath($attach['path'], $attach['ifthumb']&1), 400, 300, $url),
				'miniUrl' => Pw::getPath($attach['path'], $attach['ifthumb'])
			);
		} else {
			$atype = 'downattach';
			/*
			if ($attach['needrvrc'] > 0) {
				!$attach['ctype'] && $attach['ctype'] = ($attach['special'] == 2) ? 'money' : 'rvrc';
				if ($attach['type'] == 'img') {
					$a_url = geturl($attach['attachurl'], 'show');
					$attach['img'] = cvpic($a_url[0].'?'.$attach['size'], 1, $db_windpost['picwidth'], $db_windpost['picheight'], $attach['ifthumb'] & 1);
				}
				if ($attach['special'] == 2) {
					$db_sellset['price'] > 0 && $attach['needrvrc'] = min($attach['needrvrc'], $db_sellset['price']);
				}
			}
			*/
			$attach += array(
				'cname' => '',
				'ext' => strtolower(substr(strrchr($attach['name'],'.'),1))
			);
		}
		return array($atype, $attach);
	}

	protected function _getData($tid, $pids) {
		$tmp = array();
		$attachs = $this->_getAttachService()->getAttachByTid($tid, $pids);
		foreach ($attachs as $key => $value) {
			$tmp[$value['pid']][$key] = $value;
		}
		foreach ($tmp as $key => $value) {
			ksort($tmp[$key]);
		}
		return $tmp;
	}

	protected function _init() {
		foreach ($this->attachs as $pid => $values) {
			foreach ($values as $key => $value) {
				list($atype, $value) = $this->analyse($value);
				$this->showlist[$pid][$atype][$key] = $value;
				$this->attachs[$pid][$key] = $value;
				$this->attachs[$pid][$key]['atype'] = $atype;
			}
		}
	}

	protected function _getAttachService() {
		return Wekit::load('attach.PwThreadAttach');
	}
}
?>