<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * 帖子内容页回复列表数据接口
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwReadDataSource.php 16856 2012-08-29 04:27:45Z jieyin $
 * @package forum
 */

abstract class PwReadDataSource {
	
	public $page = 1;
	public $perpage = 20;
	public $maxpage = 1;
	public $total = 1;
	public $firstFloor;
	public $asc = true;

	protected $data = array();
	protected $urlArgs = array();
	protected $_uids = array();
	protected $_aids = array();

	public function setPage($page) {
		$this->page = $page;
	}

	public function setPerpage($perpage) {
		$this->perpage = intval($perpage);
	}

	public function setDesc($desc) {
		$this->asc = !$desc;
		$desc && $this->urlArgs['desc'] = $desc;
	}

	abstract public function execute();

	public function &getData() {
		return $this->data;
	}
	
	public function getUser() {
		return $this->_uids;
	}

	public function getAttach() {
		return $this->_aids;
	}

	public function getUrlArgs($except = '') {
		$args = $this->urlArgs;
		if ($except && isset($args[$except])) {
			unset($args[$except]);
		}
		return $args ? '&' . http_build_query($args) : '';
	}
}