<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('SRV:forum.srv.threadList.PwThreadDataSource');

/**
 * 帖子列表数据接口 / 特殊列表
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwSearchThread.php 16394 2012-08-23 06:28:06Z long.shi $
 * @package forum
 */

class PwSearchThread extends PwThreadDataSource {
	
	protected $so;
	protected $forum;

	public function __construct($forum) {
		Wind::import('SRV:forum.vo.PwThreadSo');
		$this->forum = $forum;
		$this->so = new PwThreadSo();
		$this->so->setFid($forum->fid)->setDisabled(0);
	}

	public function setType($type) {
		$this->so->setTopicType($type);
		$this->urlArgs['type'] = $type;
	}

	public function setOrderby($order) {
		if ($order == 'postdate') {
			$this->so->orderbyCreatedTime(0);
		}
		$this->urlArgs['orderby'] = $order;
	}

	public function getTotal() {
		$_tmp = $this->so->getData();
		if (count($_tmp) == 2) {
			return $this->forum->foruminfo['threads'];
		}
		return $this->_getThreadDs()->countSearchThread($this->so);
	}

	public function getData($limit, $offset) {
		return $this->_getThreadDs()->searchThread($this->so, $limit, $offset);
	}

	protected function _getThreadDs() {
		return Wekit::load('forum.PwThread');
	}
}