<?php
/**
 * hook列表更新
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwHookRefresh.php 18145 2012-09-11 10:56:21Z long.shi $
 * @package hook.srv
 */
class PwHookRefresh {
	
	public $conf = 'CONF:hooks.php';
	
	/**
	 * 由hooks.php导入数据库
	 *
	 * @return boolean
	 */
	public function refresh() {
		$conf = @include Wind::getRealPath($this->conf, true);
		if (!$conf || !is_array($conf)) return new PwError('fail');
		$hooks = $inject = array();
		foreach ($conf as $k => $v) {
			$hooks[] = array(
				'name' => $k,
				'app_name' => 'system',
				'created_time' => Pw::getTime(),
				'document' => implode("\r\n",
					array($v['description'], implode("\n", (array) $v['param']), $v['interface'])));
			foreach ($v['list'] as $k1 => $v1) {
				$inject[] = array(
					'hook_name' => $k,
					'alias' => $k1,
					'class' => $v1['class'],
					'method' => $v1['method'],
					'loadway' => $v1['loadway'],
					'expression' => $v1['expression'],
					'created_time' => Pw::getTime());
			}
		}
		try {
			/* @var $db WindConnection */
			$db = Wind::getComponent('db');
			$db->execute('TRUNCATE TABLE {{hook}}');
			$db->execute('TRUNCATE TABLE {{hook_inject}}');
		} catch (Exception $e) {
			return new PwError('fail');
		}
		Wekit::load('hook.PwHooks')->batchAdd($hooks);
		Wekit::load('hook.PwHookInject')->batchAdd($inject);
		return true;
	}
}

?>