<?php
Wind::import('SRC:library.base.PwBaseDao');
/**
 * 后台管理LOG DAO服务
 *
 * @author Gao Wang <Foxsee@qq.com>
 * @version $Id: PwAdminLogDao.php 3217 2011-12-14 06:42:36Z yishuo $
 * @package nav
 */

class PwAdminLogDao extends PwBaseDao {
	
	protected $_table = 'admin_log';
	protected $_dataStruct = array('logid', 'userid','username', 'operation','ip', 'timestamp');

	/**
	 * 添加一条管理操作信息
	 *
	 * @param arrar data
	 * return int
	 */
	public function addAdminLog($data){
		if (!$data = $this->_filterStruct($data)) return false;
		$sql = $this->_bindTable('INSERT INTO %s SET ') . $this->getConnection()->sqlSingle($data);
		$this->getConnection()->execute($sql);
		return $this->getConnection()->lastInsertId();
	}

	/**
	 * 获取LOG列表
	 *
	 * @param int $userid 用户ID
	 * return array
	 */
	public function getAdminLogList($userid=''){
		$where= ($userid>0)?' WHERE userid=?':'';
		$sql = $this->_bindTable("SELECT * FROM %s  $where ORDER BY logid DESC");
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll();
	}

	
}