<?php
/**
 * Enter description here ...
 * 
 * @author peihong.zhangph <peihong.zhangph@aliyun-inc.com> Jan 9, 2012
 * @link http://www.phpwind.com
 * @copyright 2011 phpwind.com
 * @license
 * @version $Id: PwMessageMessages.php 3407 2012-01-11 09:00:39Z peihong.zhangph $
 */

class PwMessageMessages {
	
	/**
	 * 获取私信
	 * 
	 * @param int $id
	 */
	public function getMessageById($id){
		return $this->_getWindidMessage()->getMessageById($id);
	}
	
	public function readMessages($dialogId,$messageIds){
		return $this->_getWindidMessage()->readMessages($dialogId,$messageIds);
	}
	
	public function readDialogMessages($dialogId){
		return $this->_getWindidMessage()->readDialogMessages($dialogId);
	}
	/**
	 * 批量更新私信分组
	 *
	 * @param int $uid
	 * @param array $fromUids
	 * @param array $fields
	 * return bool
	
	public function updateMessageAggregateds($uid,$fromUids,$fields){
		$uid = intval($uid);
		if ($uid < 1 || !is_array($fromUids) || !count($fromUids)) return false;
		return $this->_getAggregatedDao()->updateMessageAggregateds($uid, $fromUids, $fields);
	}
	 */
	
	/**
	 * 获取消息分组信息
	 * 
	 * @param int $uid
	 * @param int $from_uid
	 
	public function getAggregatedMessageByUid($uid,$from_uid){
		$uid = intval($uid);
		$from_uid = intval($from_uid);
		if ($uid < 1 || $from_uid < 1) return array();
		return $this->_getAggregatedDao()->getAggregatedMessageByUid($uid,$from_uid);
	}
	*/
	
	/**
	 * 获取多组消息分组信息
	 * 
	 * @param int $uid
	 * @param array $fromUids
	 */
	public function getDialogByUids($uid,$fromUids){
		return $this->_getWindidMessage()->getDialogByUids($uid,$fromUids);
	}
	
	/**
	 * 获取多组消息分组信息
	 * 
	 * @param int $uid
	 * @param int $fromUid
	 */
	public function getDialogByUid($uid,$fromUid){
		return $this->_getWindidMessage()->getDialogByUid($uid,$fromUid);
	}
	
	public function fetchDialogByDialogIds($dialogIds){
		return $this->_getWindidMessage()->fetchDialogByDialogIds($dialogIds);
	}
	
	/**
	 * 统计分组消息列表数量
	 * 
	 * @param int $uid
	 * @return int 
	 
	public function countAggregatedMessages($uid) {
		$uid = intval($uid);
		if ($uid < 1) return false;
		return $this->_getAggregatedDao()->countAggregatedMessages($uid);
	}
	*/
	
	/**
	 * 获取分组消息列表
	 * 
	 * @param int $uid
	 * @param int $start
	 * @param int $limit
	 * @return array 
	
	public function getAggregatedMessages($uid,$start,$limit){
		$uid = intval($uid);
		if ($uid < 1) return false;
		return $this->_getAggregatedDao()->getAggregatedMessages($uid,$start,$limit);
	}
	 */
	
	/**
	 * 批量删除消息
	 * 
	 * @param int $ids
	 * @return bool 
	 
	public function deleteMessagesByIds($ids) {
		if (!is_array($ids) || !count($ids)) return false;
		$this->_getRelationDao()->delRelationsByMessageIds($ids);
		return $this->_getDao()->deleteMessgaes($ids);
	}
	*/
	
	/**
	 * 根据$dialogId获取私信关系
	 * 
	 * @param int $dialogId
	 * @param int $messageId
	 * @return bool 
	 */
	public function getDialogMessageRelation($dialogId,$limit = 20,$start = 0) {
		return $this->_getWindidMessage()->getDialogMessageRelation($dialogId,$limit,$start);
	}
	
	/**
	 * 删除单条用户消息关系
	 * 
	 * @param int $dialogId
	 * @param int $messageId
	 * @return bool 
	 */
	public function deleteMessageRelation($dialogId,$messageId) {
		return $this->_getWindidMessage()->deleteRelation($dialogId,$messageId);
	}
	
	/**
	 * 获取用户消息配置
	 * 
	 * @param int $uid
	 * @return array 
	 */
	public function getMessageConfig($uid) {
		$uid = intval($uid);
		if ($uid < 1) return array();
		return $this->_getMessageConfigDao()->getMessageConfig($uid);
	}
	
	/**
	 * 批量获取用户消息配置
	 * 
	 * @param array $uids
	 * @return array 
	 */
	public function fetchMessageConfig($uids) {
		if (!is_array($uids) || !count($uids)) {
			return array();
		}
		return $this->_getMessageConfigDao()->fetchMessageConfig($uids);
	}
	
	/**
	 * 用户配置
	 * 
	 * @param array $data
	 * @return int
	 */
	public function setMessageConfig($uid,$privacy,$notice_types) {
		$uid = intval($uid);
		if ($uid < 1) return array();
		$data = array(
			'uid'			=> $uid,
			'privacy'		=> $privacy,
			'notice_types'  => $notice_types
		);
		return $this->_getMessageConfigDao()->setMessageConfig($data);
	}
	
	/**
	 * 删除单条用户消息关系
	 * 
	 * @param int $dialogId
	 * @param int $messageId
	 * @return bool 
	 */
	public function updateDialog($dialogId,WindidMessageDm $dm) {
		return $this->_getWindidMessage()->updateDialog($dialogId,$dm);
	}
	
	/** 
	 * 获得windidMessage DS
	 *
	 * @return WindidMessage
	 */
	private function _getWindidMessage() {
		return Windid::load('message.WindidMessage');
	}

	/**
	 * 
	 * Enter description here ...
	 * @return PwMessageConfigDao
	 */
	private function _getMessageConfigDao(){
		return Wekit::loadDao('message.dao.PwMessageConfigDao');
	}
}