<?php
Wind::import('SRV:user.dm.PwUserInfoDm');
/**
 * 私信业务
 *
 * @author peihong <peihong.zhangph@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwMessageService.php 3833 2012-01-12 03:32:27Z peihong.zhangph $
 * @package src.service.message.srv
 */
class PwMessageService {
	
	/**
	 * 按用户名发送私信
	 * 
	 * @param string $username
	 * @param content $content
	 * @param int $from_uid
	 * @return PwError|boolean
	 */
	public function sendMessage($username,$content,$fromUid = 0){
		$loginUser = PwUserBo::getLoginUser();
		$fromUid or $fromUid = $loginUser->uid;
		$userInfo = $this->_getUserDs()->getUserByName($username);
		if (!$userInfo) return new PwError('Message:user.notfound');
		// 检测是否隐私设置
		$userInfos = array($userInfo['uid'] => $userInfo);
		$result = $this->_checkPrivate($userInfos);
		if ($result instanceof PwError) {
			return $result;
		}
				
		// 检测今天发了多少
		list($result,$sendnum,$maxnum) = $this->_checkTodayNum($loginUser,$result);
		if (!$result) {
			return new PwError('MESSAGE:message_max_send.error',array('{sendnum}'=>$sendnum, '{maxnum}'=>$maxnum));
		}
		return $this->sendMessageByUid($result[0], $content,$fromUid);
	}
	
	/**
	 * 检测隐私
	 * 
	 * @param array $userInfos 以uid为key的二维数组
	 * @return PwError|boolean
	 */
	private function _checkPrivate($userInfos) {
		$uids = array_keys($userInfos);
		// 检测是否有设置粉丝才能收
		$result = $this->_checkMessageFan($uids);
		if ($result !== true) {
			if (count($result) == count($uids)) {
				return new PwError('Message:private.fan.only');
			}
			$uids = array_diff($uids,$result);
		}
		// 检测是否有设置黑名单
		$result = Wekit::load('user.PwUserBlack')->checkUserBlack($this->_getLoginUserId(), $uids);
		if ($result) {
			if (count($result) == count($uids)) {
				return new PwError('Message:private.black');
			}
			$uids = array_diff($uids,$result);
		}
		return $uids;
	}
	
	/**
	 * 按用户名群发送私信
	 * 
	 * @param array $usernames
	 * @param content $content
	 * @return PwError|boolean
	 */
	public function sendMessageByUsernames($usernames,$content,$fromUid = 0){
		$loginUser = PwUserBo::getLoginUser();
		$fromUid or $fromUid = $loginUser->uid;
		$userInfos = $this->_getUserDs()->fetchUserByName($usernames);
		if (!$userInfos) {
			return new PwError('MESSAGE:user.notfound');
		}
		// 检测是否隐私设置
		$result = $this->_checkPrivate($userInfos);
		if ($result instanceof PwError) {
			return $result;
		}
		// 检测今天发了多少
		list($result,$sendnum,$maxnum) = $this->_checkTodayNum($loginUser,$result);
		if (!$result) {
			return new PwError('MESSAGE:message_max_send.error',array('{sendnum}'=>$sendnum, '{maxnum}'=>$maxnum));
		}
		foreach ($result as $uid) {
			$this->sendMessageByUid($uid,$content,$fromUid);
		}
		return true;
	}
	
	/**
	 * 
	 * 批量标记会话已读
	 * @param array $dialogIds
	 */
	public function markDialogReaded($dialogIds){
		if (!is_array($dialogIds) || !$dialogIds) return false;
		$this->_loadWindidMessageDm();
		$dm = new WindidMessageDm();
		$dm->setUnreadCount(0);
		$this->_getWindidMessage()->batchUpdateDialog($dialogIds, $dm);
	}
	
	/**
	 * 按用户ID发送私信
	 * 
	 * @param int $uid
	 * @param string $content
	 * @return PwError|boolean
	 */
	public function sendMessageByUid($uid,$content,$fromUid = 0){
		if (!$uid) return new PwError('MESSAGE:user.empty'); 
		$fromUid or $fromUid = $this->_getLoginUserId();
		if ($uid == $fromUid)  {
			return new PwError('MESSAGE:send.to.myself');
		}
		$content = strip_tags($content);
		$result = $this->_getWindidMessageService()->sendMessageByUid($uid, $content, $fromUid);
		if ($result instanceof WindidError) {
			return new PwError($result->getCode());
		}
		/* @var $creditBo PwCreditBo */
		Wind::import('SRV:credit.bo.PwCreditBo');
		$creditBo = PwCreditBo::getInstance();
		$creditBo->operate('sendmsg', new PwUserBo($fromUid));
		// 发消息扩展
		$this->_getHook()->runDo('addMessage', $uid, $fromUid, $content);   
			
		if ($result) {
			//发件人通知
			$params = array('from_uid' => $uid,'to_uid' => $fromUid,'content' => $content,'is_send' => 1);
			$this->_getNoticeService()->sendNotice($fromUid,'message',$uid,$params,false);
		
			//收件人通知
			$params = array('from_uid' => $fromUid,'to_uid' => $uid,'content' => $content);
			$this->_getNoticeService()->sendNotice($uid,'message',$fromUid,$params,false);
			//更新用户表未读数
			$this->updateUserMessage($uid);
		}
		//记录每天发送数量
		$this->_getUserBehaviorDs()->replaceDayBehavior($fromUid,'message_today',Pw::getTime());
		return $result;
	}
	
	/**
	 * 根据uids群发消息
	 * 
	 * @param array $uids
	 * @param string $content
	 * @return PwError|boolean
	 */
	public function sendMessagesByUids($uids,$content,$fromUid = 0){
		$fromUid or $fromUid = $this->_getLoginUserId();
		if (!is_array($uids)) return false;
		foreach ($uids as $uid) {
			$this->sendMessageByUid($uid, $content, $fromUid);
		}
		return true;
	}

	
	/**
	 * 
	 * 获取分组列表
	 * 
	 * @param int $uid
	 * @param int $start
	 * @param int $limit
	 * @return array 
	 */
	public function getDialogs($uid,$start,$limit){
		return $this->_getWindidMessageService()->getDialogs($uid, $start, $limit);
	}
	
	/**
	 * 
	 * 获取一条对话信息
	 * @param int $dialogId
	 */
	public function getDialog($dialogId){
		return $this->_getWindidMessage()->getDialog($dialogId);
	}
	
	/**
	 * 
	 * 根据uid获取对话信息
	 * @param int $toUid
	 * @param int $fromUid
	 */
	public function getDialogByUid($toUid,$fromUid){
		return $this->_getWindidMessage()->getDialogByUid($toUid,$fromUid);
	}
	
	/**
	 * 获取对话消息列表
	 *
	 * @param int $uid
	 * @param int $from_uid
	 * @param int $start
	 * @param int $limit
	 * @return array
	 */
	public function getDialogMessageList($dialogId,$limit,$start) {
		// 对话消息分页
		list($count,$messages) = $this->_getWindidMessageService()->getDialogMessages($dialogId, $limit, $start);
		krsort($messages);
		return array($count,$messages);
	}
	
	/**
	 * 
	 * 重新计算用户私信数
	 * @param int $uid
	 */
	public function resetUserMessages($uid){
		$uid = intval($uid);
		if ($uid < 1) return false;
		list($total,$unreads) = $this->_getWindidMessage()->countUserMessages($uid);
		return $this->updateUserMessage($uid,$unreads,false);
	}
	
	/**
	 * 
	 * 删除会话
	 * @param array $dialogIds
	 */
	public function batchDeleteDialog($dialogIds){
		return $this->_getWindidMessageService()->batchDeleteDialog($dialogIds);
	}
	
	/**
	 * 
	 * 后台清理用户消息接口
	 * @param int $uid
	 * @param bool $message 是否删除私信
	 * @param bool $notice 是否删除通知
	 */
	public function deleteUserMessages($uid,$message = true, $notice = true){
		$rs1 = $message ? $this->_getWindidMessageService()->deleteUserMessages($uid) : true;
		$rs2 = $notice ? Wekit::load('SRV:message.srv.PwNoticeService')->deleteNoticeByUid($uid) : true;
		return $rs1 && $rs2;
	}
		
	/**
	 * 搜索消息
	 * 
	 * @param int $start
	 * @param int $limit
	 * @param int $from_uid
	 * @param int $starttime
	 * @param int $endtime
	 * @return array 
	 */
	public function getMessagesByUid($start,$limit,$from_uid,$starttime = 0,$endtime = 0,$keyword) {
		$count = $this->_getWindidMessage()->countMessageByUid($from_uid,$keyword,$starttime,$endtime);
		if ($count < 1) return array(0,array());
		$messages = $this->_getWindidMessage()->getMessagesByUid($start,$limit,$from_uid,$keyword,$starttime,$endtime);
		$uids = $array = array();
		foreach ($messages as $v) {
			$uids[] = $v['from_uid'];
		}
		// 组装用户数据
		$userInfos = $this->_getUserDs()->fetchUserByUid($uids);
		if (!$userInfos) return array(0,array());
		foreach ($messages as $v) {
			$v['username'] = $userInfos[$v['from_uid']]['username'];
			$array[] = $v;
		}
		return array($count,$array);
	}
	
	/**
	 * 
	 * 后台根据搜索结果的message id删除消息
	 */
	public function deleteMessageByMessageIds($messageIds){
		$relations = $this->_getWindidMessage()->getRelationsByMessageIds($messageIds);
		if (!$relations) return true;
		$dialogIds = $relationIds = array();
		foreach ($relations as $v) {
			$dialogIds[] = $v['dialog_id'];
			$relationIds[$v['dialog_id']][] = $v['id'];
		}
		if (!$dialogIds) return true;
		$dialogIds = array_unique($dialogIds);
		foreach ($dialogIds as $dialogId) {
			$dialog = $this->getDialog($dialogId);
			if (!$dialog || !$relationIds[$dialogId]) continue;
			$this->_getWindidMessage()->batchDeleteRelation($relationIds[$dialogId]);
			$this->resetDialogMessages($dialogId);
			$this->resetUserMessages($dialog['to_uid']);
			$dialog_relation = $this->_getWindidMessage()->getDialogMessages($dialogId,1);
			if (!$dialog_relation) {
				$this->_getWindidMessage()->batchDeleteDialog(array($dialogId));
				$this->_getNoticeService()->deleteNoticeByType($dialog['to_uid'],'message',$dialog['from_uid']);
			}
		}
		$this->_getWindidMessage()->batchDeleteMessage($messageIds);
		return true;
	}
	
	/**
	 * 设置消息
	 *
	 * @param int $uid
	 * @param array $data
	 * @param int $message_tone
	 * @return array
	 */
	public function setMessageConfig($uid,$privacy,$notice_types,$message_tone) {
		$uid = intval($uid);
		$message_tone = intval($message_tone);
		if ($uid < 1) return false;
		Wind::import('SRC:user.dm.PwUserInfoDm');
		$dm = new PwUserInfoDm($uid);
		$dm->setMessage_tone($message_tone);
		$this->_getUserDs()->editUser($dm,PwUser::FETCH_DATA);
		return $this->_getMessagesDs()->setMessageConfig($uid,(int)$privacy,$notice_types);
	}
	
	/**
	 * 更新用户表未读数
	 * 
	 * @param int $uid
	 * @param int $num
	 * @param bool $increase
	 * @return int
	 */
	public function updateUserMessage($uid,$num=1,$increase = true) {
		//更新用户表未读数
		Wind::import('SRV:user.dm.PwUserInfoDm');
		$dm = new PwUserInfoDm($uid);
		if ($increase) {
			$dm->addMessages($num);
		} else {
			$dm->setMessageCount($num);
		}
		return $this->_getUserDs()->editUser($dm, PwUser::FETCH_DATA);
	}
	
	/**
	 * 
	 * 添加用户黑名单
	 * @param int $uid
	 * @param int $blackUid
	 */
	public function addBlackUser($uid,$blackUid){
		return $this->_getWindidMessageService()->addBlackUser($uid, $blackUid);
	}

	public function resetDialogMessages($dialogId){
		$this->_getWindidMessageService()->resetDialogMessages($dialogId);
	}
	
	/**
	 * 检查发私信权限
	 * 
	 * @param int $uid
	 * @param int $blackUid
	 */
	public function checkAddMessageRight(PwUserBo $user) {
		if ($user->uid < 1) {
			return new PwError('USER:user.not.login');
		}
		if ($user->getPermission('message_allow_send') < 1) {
			return new PwError('MESSAGE:allow_send.right.error');
		}
		return true;
	}

	/**
	 * 检测是否粉丝
	 *
	 * @param array $uids
	 * @return array | bool
	 */
	private function _checkMessageFan($uids) {
		!is_array($uids) && $uids = array($uids);
		$loginUid = $this->_getLoginUserId();
		$configs = $this->_getMessagesDs()->fetchMessageConfig($uids);
		$privateFans = array();
		foreach ($configs as $v) {
			$v['privacy'] && $privateFans[] = $v['uid'];
		}
		if (!$privateFans) {
			return true;
		}
		$fans = Wekit::load('attention.PwAttention')->fetchFans($loginUid,$privateFans);
		$result = array_diff($privateFans,array_keys($fans));
		if ($result) {
			return $result;
		}
		return true;
	}

	/**
	 * 检测今日发消息数量
	 *
	 * @param PwUserBo $user
	 * @param int $countUser
	 * @return PwError | bool
	 */
	private function _checkTodayNum(PwUserBo $user,$touids) {
		!is_array($touids) && $touids = array($touids);
		$behavior = $this->_getUserBehaviorDs()->getBehavior($user->uid,'message_today');
		$dayMax = $user->getPermission('message_max_send');
		$countUser = count($touids);
		if ($behavior['number']+$countUser > $dayMax) {
			$touids = array_slice($touids, 0, $dayMax - $behavior['number']);
		}
		return array($touids,$behavior['number'],$dayMax);
	}
	
	private function _loadWindidMessageDm(){
		Wind::import('WINDID:service.message.dm.WindidMessageDm');
	}
	
	/** 
	 * 获得windidMessage DS
	 *
	 * @return WindidMessage
	 */
	private function _getWindidMessage() {
		return Windid::load('message.WindidMessage');
	}
	
	/** 
	 * 获得WindidMessageService
	 *
	 * @return WindidMessageService
	 */
	private function _getWindidMessageService() {
		return Windid::load('message.srv.WindidMessageService');
	}
	
	/**
	 * 
	 * Enter description here ...
	 * @return PwNoticeService
	 */
	private function _getNoticeService(){
		return Wekit::load('message.srv.PwNoticeService');
	}
	
	private function _getLoginUserId(){
		$loginUser = PwUserBo::getLoginUser();
		return $loginUser->uid;
	}
	
	/**
	 * 
	 * Enter description here ...
	 * @return PwUser
	 */
	private function _getUserDs(){
		return Wekit::load('user.PwUser');
	}
	
	/**
	 * 
	 * Enter description here ...
	 * @return PwMessageMessages
	 */
	private function _getMessagesDs(){
		return Wekit::load('message.PwMessageMessages');
	}
	
	/**
	 * 
	 * @return PwHookService
	 */
 	private function _getHook() {
 		return new PwHookService('PwMessageService', 'PwMessageDoBase');
 	}
 	
	
	/**
	 * PwUserBehavior
	 * 
	 * @return PwUserBehavior
	 */
	private function _getUserBehaviorDs() {
		return Wekit::load('user.PwUserBehavior');
	}
}