<?php
/**
 * the last known user to change this file in the repository  <$LastChangedBy: yanchixia $>
 * @author $Author: yanchixia $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwNavBo.php 17614 2012-09-07 03:14:46Z yanchixia $ 
 * @package 
 */
class PwNavBo {
	
	protected $default = array('m' => 'default', 'c' => 'index', 'a' => 'run');
	protected $forum = array();
	protected $router = array();
	
	public function setForum($cateid = 0, $fid = 0, $tid = 0) {
		$this->forum['fid'] = $fid;
		$this->forum['cateid'] = $cateid;
		$this->forum['tid'] = $tid;
	}
	

	public function isForum() {
		if ($this->router['m'] == 'bbs') return true;
		return false;
	}
	
	/**
	 * 需要定位时调用
	 * Enter description here ...
	 */
	public function setRouter() {
		$router = Wind::getApp()->getComponent('router');
		$this->router['m'] = $router->getModule(); 
    	$this->router['c'] = $router->getController(); 
    	$this->router['a'] = $router->getAction();
	}
	
	public function getNav($type, $current = false) {
		$childRating = $rootRating = array();
		$list = $this->_getNavDs()->getNavByType($type);
		if ($current) $rating = $this->routRating();
		foreach ($list AS $key=>$value) {
			$list[$key]['name'] = $this->bindHtml($value);
			if ($current) {
				if ($_k = array_search($value['sign'], $rating)) {
					//根导航定位
					$rootRating[$key] = $_k;
				}
			}
			
			foreach ($value['child'] AS $ckey=>$cvalue) {
				$list[$key]['child'][$ckey]['name'] = $this->bindHtml($cvalue);
				if ($current) {
					if ($_k = array_search($cvalue['sign'], $rating)) {
						//子导航定位
						$childRating[$key][$ckey] = $_k;
					}
				}
			}
		}

		asort($rootRating);
		foreach ($childRating AS $_k=>$_c) {
			asort($_c);
			$childCurrentId = array_shift(array_keys($_c));
			if ($childCurrentId) $list[$_k]['child'][$childCurrentId]['current'] = true;
		}
		$rootCurrentId = array_shift(array_keys($rootRating));
		if ($rootCurrentId) $list[$rootCurrentId]['current'] = true;
		return $list;
	}
	
	/**
	 * 可能的路由等级
	 * key越小，说明当前定位优先级越高
	 * Enter description here ...
	 */
	protected function routRating() {
		$rating = array();
		$rating[] = '';
		$m = $this->router['m'];
		$c = $this->router['c'];
		$a = $this->router['a'];
		$rating[] = $m .'|'. $c .'|'. $a.'|';
    	if ($m == 'bbs') { //帖子兼容
    		$rating[] = $m .'|'. $c .'|'. $a .'|'.$this->forum['tid'].'|';
    		$rating[] = $m .'|thread|'. $this->default['a'] .'|'.$this->forum['fid'].'|';
    		if ($c == 'cate') {
    			$rating[] = $m .'|cate|'. $this->default['a'] .'|'.$this->forum['fid'].'|';
    		} else {
    			$rating[] = $m .'|cate|'. $this->default['a'] .'|'.$this->forum['cateid'].'|';
    		}
    		$rating[] = $m .'|forum|'. $this->default['a'] .'|';
    	}
    	
    	if ($m == 'special') { //门户兼容
    		$id = Wind::getApp()->getRequest()->getGet('id');
    		$rating[] = $m .'| '.$c.' |'. $a .'|'.$id.'|';
    	}
    	$rating[] = $m .'|'. $c .'|'. $this->default['a'].'|';
    	$rating[] = $m .'|'. $this->default['c'] .'|'. $this->default['a'].'|';
    	$rating[] = $this->default['m'] .'|'. $this->default['c'] .'|'. $this->default['a'].'|';
    	
		return $rating;
	}

	protected function bindHtml($data = '') {
		list($color, $bold, $italic, $underline) = explode('|', $data['style']);
		$html = '<a href="'.$data['link'].'"';
		if ($data['alt']) {
			$html .= ' title="'.$data['alt'].'"';
		}
		if ($data['target']) {
			$html .= ' target="_blank"';
		}
		if (empty($color) && empty($bold) && empty($italic) && empty($underline)){
			$html .='>'.$data['name'].'</a>';
		} else {
			$html .= ' style="';
			!empty($color) && $html .= 'color:'.$color.';';
			!empty($bold) && $html .= 'font-weight:bold;';
			!empty($italic) && $html .= 'font-style:italic;';
			!empty($underline) && $html .= 'text-decoration:underline;';
			$html .= '">'.$data['name'].'</a>';
		}
		return $html;
	}
	
	private function _getNavDs() {
		return Wekit::load('SRV:nav.PwNav');
	}
}