<?php

 /**
  * 在线服务记录接口
  * 
  * @author $Author: gao.wanggao $ Foxsee@aliyun.com
  * @copyright ©2003-2103 phpwind.com
  * @license http://www.phpwind.com
  * @version $Id: PwOnlineService.php 17074 2012-08-31 02:34:45Z gao.wanggao $ 
  * @package 
  */

class PwOnlineService {
	
	public $time; //当前时间
	public $isVisitorTime;//有效用户时间(秒) 访问网站多久开始算在线
	public $spaceTime; //记录活动间隔时间
	public $offlineTime;//无活动离线时间(秒)
	
	public function __construct() {
		$config = Wekit::config('site');
		$this->time = Pw::getTime();
		$this->isVisitorTime = 1;
		$this->spaceTime = 60;
		$this->offlineTime = $config['onlinetime'] * 60;
	}
	
	/**
	 * 浏览时更新状态
	 * 
	 * @param string $clientIp
	 * @return bool|string
	 */
	public function visitOnline($clientIp) {
		$vistor = $this->getVisitor();
		if ($vistor === false || empty($clientIp)) {					//不标记
			return false;			
		} elseif ($vistor === true){									//初始标记
			$this->signVisitor($clientIp, $this->time, $this->time);
			return false;	
		} else {																	
			list($ip, $createdTime, $modifyTime) = $vistor;
			if (empty($ip) || empty($createdTime) || empty($modifyTime)) {
				$this->signVisitor($clientIp, $this->time, $this->time);	//初始标记
				return false;
			} else {													//更新标记	
				$this->signVisitor($ip, $createdTime, $this->time);
				return $createdTime;
			}
		}
	}
	
	/**
	 * 登录时更新状态
	 * 
	 * @param int $uid
	 * @param string $username
	 * @param int $gid
	 * @return void
	 */
	public function loginOnline($uid, $username, $gid, $ip) {
		if ($uid < 0) return false;
		$dm = Wekit::load('online.dm.PwOnlineDm');
		$dm->setUid($uid)
			->setUsername($username)
			->setModifytime($this->time)
			->setCreatedtime($this->time)
			->setGid($gid);
		Wekit::load('online.PwUserOnline')->replaceInfo($dm);
		
		//游客转为登陆用户
		$vistor = $this->getVisitor();
		if (!is_array($vistor)) return false;
		list($ip, $createdTime, $modifyTime) = $vistor;
		Wekit::load('online.PwGuestOnline')->deleteInfo($ip, $createdTime);
		$this->signVisitor($ip, $this->time, $this->time);
	}
	
	/**
	 * 登出时更新状态
	 * 
	 * @param int $uid
	 * @return void
	 */
	public function logoutOnline($uid) {
		$vistor = $this->getVisitor();
		if (!is_array($vistor)) return false;
		list($ip, $createdTime, $modifyTime) = $vistor;
		//用户转换为游客
		$dm = Wekit::load('online.dm.PwOnlineDm');
		$dm->setIp($uid)
			->setModifytime($this->time)
			->setCreatedtime($this->time);
		Wekit::load('online.PwGuestOnline')->replaceInfo($dm);
		Wekit::load('online.PwUserOnline')->deleteInfo($uid);
		$this->signVisitor($ip, $this->time, $this->time);
	}
	
	/**
	 * 标记一个访问者
	 * 
	 * @param string $ip
	 * @param int $createdTime
	 * @param int $modifyTime
	 */
	public function signVisitor($ip, $createdTime, $modifyTime) {
		$ip = ip2long($ip);
		$sign = Pw::encrypt($ip.'_'.$createdTime.'_'.$modifyTime);
		return Pw::setCookie('visitor',$sign);
	}
	
	/**
	 * 获取本地的访问标记
	 * @return bool|array
	 */
	public function getVisitor() {
		$sign = Pw::getCookie('visitor');
		if (empty($sign)) return true; 
		$sign = Pw::decrypt($sign);
		$signs = explode('_',$sign);
		list($ip, $createdTime, $modifyTime) = $signs;
		$modifyTime = (int)$modifyTime;
		$createdTime = (int)$createdTime;
		if ($createdTime < 1 || $modifyTime < 1) return true; 
		$onlineTime = $this->time - $modifyTime;
		if ($createdTime == $modifyTime && $onlineTime >= $this->isVisitorTime) return $signs;
		if ($onlineTime >= $this->spaceTime ) return $signs;
		return false;
	}
	
	public function clearNotOnline() {
		$expiredTime = $this->time - $this->offlineTime;
		Wekit::load('online.PwUserOnline')->deleteInfoByTime($expiredTime);
		Wekit::load('online.PwGuestOnline')->deleteInfoByTime($expiredTime);
	}
	
	public function updateCountOnlineTime($uid, $startTime, $endTime) {
		$onlineTime = (int)$endTime - (int)$startTime;
		$uid = (int)$uid;
		if ($uid < 0) return false;
		Wind::import('SRV:user.dm.PwUserInfoDm');
		$userDm = new PwUserInfoDm();
		$userDm->setUid($uid)->setOnline($onlineTime);
		$ds = Wekit::load('user.PwUser');
		$ds->editUser($userDm, PwUser::FETCH_DATA);
	}
}
?>