<?php
/**
 * 用户数据扩展表
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUserDao.php 8252 2012-04-17 08:32:05Z jieyin $
 * @package src.service.user.dao
 */
class PwUserDao extends PwBaseDao {

	protected $_table = 'user';
	protected $_pk = 'uid';
	protected $_dataStruct = array('uid', 'username', 'email', 'password', 'regdate', 'realname', 'status', 'vippoint', 'memberpoint', 'groupid', 'vipid', 'memberid', 'groups');

	/**
	 * 根据用户ID获得用户的扩展数据
	 *
	 * @param int $uid 用户ID
	 * @return array
	 */
	public function getUserByUid($uid) {
		return $this->_get($uid);
	}
	
	/**
	 * 根据用户名获得用户信息
	 *
	 * @param string $username
	 * @return array
	 */
	public function getUserByName($username) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE username=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($username));
	}

	/**
	 * 根据用户的email获得用户信息
	 *
	 * @param string $email
	 * @return array
	 */
	public function getUserByEmail($email) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE email=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($email));
	}

	/** 
	 * 根据用户ID列表获取ID
	 *
	 * @param array $uids
	 * @return array
	 */
	public function fetchUserByUid($uids) {
		return $this->_fetch($uids, 'uid');
	}

	/**
	 * 根据用户名列表批量获得用户信息
	 *
	 * @param array $usernames
	 * @return array
	 */
	public function fetchUserByName($usernames) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE username IN %s', $this->getTable(), $this->sqlImplode($usernames));
		$rst = $this->getConnection()->query($sql);
		return $rst->fetchAll('uid');
	}

	/** 
	 * 插入用户扩展数据
	 *
	 * @param array $fields 用户数据
	 * @return boolean|Ambigous <number, boolean, rowCount>
	 */
	public function addUser($fields) {
		$this->_add($fields, false);
		return true;
	}

	/** 
	 * 根据用户ID更新用户扩展数据
	 *
	 * @param int $uid    用户ID
	 * @param array $fields  用户扩展数据
	 * @return boolean|int
	 */
	public function editUser($uid, $fields, $increaseFields = array()) {
		return $this->_update($uid, $fields, $increaseFields);
	}

	/** 
	 * 删除用户数据
	 *
	 * @param int $uid  用户ID
	 * @return int
	 */
	public function deleteUser($uid) {
		return $this->_delete($uid);
	}

	/** 
	 * 批量删除用户信息
	 *
	 * @param array $uids 用户ID
	 * @return int
	 */
	public function batchDeleteUser($uids) {
		return $this->_batchDelete($uids);
	}

	/**
	 * 根据用户ID获得用户的扩展数据
	 *
	 * @param int|array $type 用户组ID 0：普通用户组，-1：VIP用户组，>0特殊组
	 * @param int $limit 查询的条数
	 * @param int $start 开始位置
	 * @return boolean|array
	 */
	public function fetchByGroupid($type, $limit = 10, $start = 0) {
		$type = (array) $type;
		$sql = $this->_bindSql('SELECT * FROM %s WHERE `groupid` IN %s %s', $this->getTable(), $this->sqlImplode($type), $this->sqlLimit($limit, $start));
		$smt = $this->getConnection()->query($sql);
		return $smt->fetchAll('uid');
	}

	/**
	 * 根据用户ID获得用户的扩展数据
	 *
	 * @param int|array $type 用户组ID 0：普通用户组，-1：VIP用户组，>0特殊组
	 * @param int $start 开始位置
	 * @param int $limit 查询的条数
	 * @return int
	 */
	public function countByGroupid($type) {
		$type = (array) $type;
		$sql = $this->_bindSql('SELECT COUNT(`uid`) FROM %s WHERE `groupid` IN %s ', $this->getTable(), $this->sqlImplode($type));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue();
	}
}
?>