<?php
Wind::import('SRV:user.srv.bantype.PwUserBanTypeInterface');
Wind::import('SRV:user.dm.PwUserInfoDm');

/**
 * 用户禁止类型-禁止头像 扩展
 *
 * @author xiaoxia.xu <x_824@sina.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwUserBanAvatar.php 14889 2012-07-27 08:08:42Z xiaoxia.xuxx $
 * @package src.service.user.srv.bantype
 */
class PwUserBanAvatar implements PwUserBanTypeInterface {
	
	/* (non-PHPdoc)
	 * @see PwUserBanTypeInterface::afterBan()
	 */
	public function afterBan(PwUserBanInfoDm $dm) {
		/* @var $userDs PwUser */
		$userDs = Wekit::load('SRV:user.PwUser');
		$info = $userDs->getUserByUid($dm->getField('uid'), PwUser::FETCH_MAIN);
		if ($info['status'] & PwUser::STATUS_BAN_AVATAR) return true;//已经禁止不需要再次更改
		$userDm = new PwUserInfoDm();
		$userDm->setUid($dm->getField('uid'))
			->updateStatus(PwUser::STATUS_BAN_AVATAR);
		$userDs->editUser($userDm, PwUser::FETCH_MAIN);
		$this->_updateAvatar($dm->getField('uid'));
		return true;
	}
	
	/* (non-PHPdoc)
	 * @see PwUserBanTypeInterface::deleteBan()
	 */
	public function deleteBan($uid) {
		/* @var $userDs PwUser */
		$userDs = Wekit::load('SRV:user.PwUser');
		$info = $userDs->getUserByUid($uid, PwUser::FETCH_MAIN);
		if (!($info['status'] & PwUser::STATUS_BAN_AVATAR)) return true;//已经解禁不需要再次更改
		
		$userDm = new PwUserInfoDm();
		$userDm->setUid($uid)
			->updateStatus(-PwUser::STATUS_BAN_AVATAR);
		/* @var $userDs PwUser */
		$userDs = Wekit::load('SRV:user.PwUser');
		$userDs->editUser($userDm, PwUser::FETCH_MAIN);
		/* @var $userSrv PwUserService */
		$userSrv = Wekit::load('SRV:user.srv.PwUserService');
		$userSrv->deleteAvatar($uid);
		return true;
	}
	
	/**
	 * 将用户的头像更新为禁止头像
	 * 
	 * TODO 【用户禁止-禁止头像】设置为禁止专用头像
	 * 
	 * @param int $uid
	 * @return boolean
	 */
	private function _updateAvatar($uid) {
		/* @var $store PwStorageLocal */
		$store = Wind::getApp()->getComponent('storage');
		Wind::import('SRV:upload.PwUpload');
		
		$fileDir = sprintf('avatar/%s/', Pw::getUserDir($uid));
		$_avatar = array('.jpg', '_middle.jpg', '_small.jpg');
		$defaultBanDir = Wind::getRealDir('PUBLIC:') . 'res/images/face/';
		foreach ($_avatar as $_item) {
			$toPath = $store->getAbsolutePath($uid . $_item, $fileDir);
			$fromPath = $defaultBanDir . 'ban' . $_item;
			PwUpload::moveUploadedFile($fromPath, $toPath);
			$store->save($fromPath, $fileDir . $uid . $_item);
		}
		return true;		
	}
	
	/* (non-PHPdoc)
	 * @see PwUserBanTypeInterface::getExtension()
	*/
	public function getExtension($fid) {
		return '全局';
	}
}