<?php
/**
 * Enter description here ...
 * 
 * @author peihong.zhangph <peihong.zhangph@aliyun-inc.com> Oct 31, 2011
 * @link http://www.phpwind.com
 * @copyright 2011 phpwind.com
 * @license
 * @version $Id: PwUserGroupsDao.php 8252 2012-04-17 08:32:05Z jieyin $
 */

class PwUserGroupsDao extends PwBaseDao {
	
	protected $_table = 'user_groups';
	protected $_pk = 'gid';
	protected $_dataStruct = array('type', 'name', 'category', 'image', 'points');
	
	/**
	 * 获取所有用户组
	 */
	public function getAllGroups() {
		$sql = $this->_bindTable("SELECT * FROM %s");
		$smt = $this->getConnection()->query($sql);
		return $smt->fetchAll('gid');
	}
	
	/**
	 * 获取一个会员组详细信息
	 *
	 * @param int $gid
	 * @return Array
	 */
	public function getGroupByGid($gid) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE gid = ?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($gid));
	}
	
	/**
	 * 根据一组gid获取用户组
	 * 
	 * @param array $gids
	 * @return array
	 */
	public function fetchGroup($gids) {
		return $this->_fetch($gids, 'gid');
	}
	
	/**
	 * 添加用户组
	 *
	 * @param array $fields
	 */
	public function addGroup($fields) {
		if (!$fields = $this->_filterStruct($fields)) {
			return false;
		}
		$sql = $this->_bindTable('INSERT INTO %s SET ') . $this->sqlSingle($fields);
		$this->getConnection()->execute($sql);
		return $this->getConnection()->lastInsertId();
	}
	
	/**
	 * 更新用户组
	 *
	 * @param int $gid
	 * @param array $fields
	 */
	public function updateGroup($gid, $fields) {
		if (!$fields = $this->_filterStruct($fields)) {
			return false;
		}
		$sql = $this->_bindTable('UPDATE %s SET ') . $this->sqlSingle($fields) . ' WHERE gid=?';
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($gid));
	}
	
	/**
	 * 删除用户组
	 *
	 * @param int $gid
	 */
	public function deleteGroup($gid) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE gid=?');
		return $this->getConnection()->createStatement($sql)->update(array($gid));
	}
	
	/**
	 * 按会员组类型获取组列表
	 *
	 * @param string $groupType
	 */
	public function getGroupsByType($groupType) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE type=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($groupType), 'gid');
	}
	
	/**
	 * 按会员组类型获取组列表（按升级点数升序）
	 *
	 * @param string $groupType
	 */
	public function getGroupsByTypeInUpgradeOrder($groupType) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE type=? ORDER BY points');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($groupType), 'gid');
	}
}