<?php
define('WEKIT_PATH', dirname(__FILE__) . DIRECTORY_SEPARATOR);
define('WEKIT_VERSION', '0.3.6');
define('NEXT_VERSION', '9.0beta');

require WEKIT_PATH . '../wind/Wind.php';

/**
 * @author Jianmin Chen <sky_hold@163.com>
 * @version $Id: wekit.php 18242 2012-09-12 04:32:29Z liusanbian $
 * @package wekit
 */
class Wekit {

	const SYSTEM_CACHE = 'WIND:cache.strategy.WindApcCache';
	protected static $_cache;
	protected static $_app;

	/**
	 * 运行当前应用
	 */
	public static function run($name = 'phpwind', $windCache = false, $components = array()) {
		$config = include WEKIT_PATH . '../conf/application.php';
		if (!empty($components)) $config['components'] = (array) $components + $config['components'];
		/* @var $application WindWebFrontController */
		$application = Wind::application($name, $config);
		if ($windCache) {
			$application->registeComponent(WindFactory::createInstance(Wind::import(self::SYSTEM_CACHE)), 'windCache');
		}
		$application->registeFilter(new PwFrontFilters());
		$application->run();
	}

	/**
	 * phpwind初始化
	 *
	 * @return void
	 */
	public static function init() {
		$_conf = include WEKIT_PATH . '../conf/directory.php';
		foreach ($_conf as $namespace => $path) {
			$realpath = realpath(WEKIT_PATH . $path);
			Wind::register($realpath, $namespace);
			define($namespace . '_PATH', $realpath . '/');
		}
		Wind::register(WEKIT_PATH, 'WEKIT');
		self::_loadBase();
	}

	/**
	 * 获取当前应用
	 *
	 * @return phpwind
	 */
	public static function app() {
		return self::$_app;
	}

	/**
	 * 创建当前应用实例
	 */
	public static function createapp() {
		if (!is_object(self::$_app)) {
			$class = Wind::import('SRC:' . Wind::getAppName());
			self::$_app = new $class();
			self::$_app->init();
			//define('TIMESTAMP', self::$_app->timestamp);
			//define('CHARSET', 'gbk');
		}
	}

	/**
	 * 获取实例
	 *
	 * @param string $path 路径
	 * @param string $loadway 加载方式
	 * @param array $args 参数
	 * @return object
	 */
	public static function getInstance($path, $loadway = '', $args = array()) {
		switch ($loadway) {
			case 'loadDao':
				return Wekit::loadDao($path);
			case 'load':
				return Wekit::load($path);
			default:
				$reflection = new ReflectionClass(Wind::import($path));
				return call_user_func_array(array($reflection, 'newInstance'), $args);
		}
	}

	/**
	 * 加载类库(单例)
	 *
	 * @param string $path 路径
	 * @return object
	 */
	public static function load($path) {
		return PwLoader::load($path);
	}

	/**
	 * 加载Dao(单例)
	 *
	 * @param string $path 路径
	 * @return object
	 */
	public static function loadDao($path) {
		return PwLoader::loadDao($path);
	}

	/**
	 * 获取Dao组合(单例)
	 *
	 * @param int $index 索引键
	 * @param array $daoMap dao列表
	 * @param string $vkey 区分符
	 * @return object
	 */
	public static function loadDaoFromMap($index, $daoMap, $vkey) {
		return PwLoader::loadDaoFromMap($index, $daoMap, $vkey);
	}

	/**
	 * 设置全局变量
	 *
	 * @param array|string|object $data
	 * @param string $key
	 * @see WindWebApplication::setGlobal
	 */
	public static function setGlobal($data, $key = '') {
		if ($key)
			$_G[$key] = $data;
		else {
			if (is_object($data)) $data = get_object_vars($data);
			$_G['G'] = $data;
		}
		Wind::getApp()->getResponse()->setData($_G, 'G', true);
	}

	/**
	 * 获得全局变量
	 *
	 * @return array|string|object
	 * @see WindWebApplication::getGlobal
	 */
	public static function getGlobal() {
		$_args = func_get_args();
		array_unshift($_args, 'G');
		return call_user_func_array(array(Wind::getApp()->getResponse(), 'getData'), $_args);
	}

	/**
	 * 获取应用配置 config
	 *
	 * @param string $namespace 默认值'site'
	 * @return mixted
	 */
	public static function config($namespace = 'site', $key = '') {
		//trigger_error('aaa');
		if (!$config = Wekit::getGlobal('C', $namespace)) {
			/* @var $configService PwConfig */
			$configService = Wekit::load('config.PwConfig');
			$config = $configService->getValues($namespace);
			Wekit::setGlobal(array($namespace => $config), 'C');
		}
		return $key ? (isset($config[$key]) ? $config[$key] : '') : $config;
	}

	/**
	 * 获取通用缓存服务
	 *
	 * @return object
	 */
	public static function cache() {
		if (self::$_cache == null) {
			Wind::import("Lib:utility.PwCacheService");
			self::$_cache = new PwCacheService();
		}
		return self::$_cache;
	}

	/**
	 * 预加载相关类文件
	 *
	 * @return void
	 */
	protected static function _loadBase() {
		Wind::import('WIND:utility.WindFolder');
		Wind::import('WIND:utility.WindJson');
		Wind::import('WIND:utility.WindFile');
		Wind::import('WIND:utility.WindValidator');
		Wind::import('WIND:utility.WindCookie');
		Wind::import('WIND:utility.WindSecurity');
		Wind::import('WIND:utility.WindString');
		Wind::import('WIND:utility.WindConvert');
		
		Wind::import('LIB:base.*');
		Wind::import('LIB:engine.extension.viewer.*');
		Wind::import('LIB:engine.component.*');
		Wind::import('LIB:engine.error.*');
		Wind::import('LIB:engine.exception.*');
		Wind::import('LIB:engine.hook.*');
		Wind::import('LIB:Pw');
		Wind::import('LIB:PwLoader');
		Wind::import('LIB:compile.PwFrontFilters');
		
		Wind::import('SRV:config.bo.PwConfigBo');
		Wind::import('SRC:windid.Windid');
		Wind::import('SRV:user.bo.PwUserBo');
	}
}

Wekit::init();