<?php
defined('WINDID_PATH') || define('WINDID_PATH', dirname(__FILE__) . DIRECTORY_SEPARATOR);
defined('TIMESTAMP') || define('TIMESTAMP', time());

//define('WINDID_CHARSET', 'utf8');
//define('WINDID_APPID', 1);
Wind::register(WINDID_PATH, 'WINDID');
Wind::import('WIND:utility.WindValidator');
Wind::import('WIND:utility.WindUtility');
Wind::import('WINDID:library.WindidUtility');
Wind::import('WINDID:library.WindidError');
Wind::import('WINDID:library.base.WindidBaseDao');

class Windid {
	
	protected static $_daoFactory = null;
	protected static $_daoInstances = array();
	private static $_daoMaps = array();

	static public function notify() {
		Wind::import('WINDID:service.config.WindidConfig');
		$config = WindidConfig::getInstance();
		if ($config->{'notifyexists' . WINDID_APPID}) {
			$notify = self::load('notify.WindidNotify');
			$notify->sendQueue();
		}
	}

	/**
	 * 加载类文件
	 *
	 * @param string $path 类文件
	 * @return object
	 */
	static public function load($path) {
		static $cls = array();
		if (!isset($cls[$path])) {
			$class = Wind::import('WINDID:service.' . $path);
			$cls[$path] = new $class();
		}
		return $cls[$path];
	}

	/**
	 * 加载DAO文件
	 *
	 * @param string $path DAO文件
	 * @return object
	 */
	public static function loadDao($path) {
		if (self::$_daoFactory === null) {
			Wind::import('WIND:dao.WindDaoFactory');
			self::$_daoFactory = new WindDaoFactory();
		}
		$dao = self::$_daoFactory->getDao('WINDID:service.' . $path);
		$dao->setDelayAttributes(array('connection' => array('ref' => 'windiddb')));
		return $dao;
	}

	/**
	 * 获取装饰Dao的工厂方法
	 *
	 * @param int $index 索引键
	 * @param array $daoMap dao列表
	 * @param string $key 区分表
	 * @return object
	 */
	public static function loadDaoMap($index, $daoMap, $vkey) {
		if (isset($daoMap[$index])) {
			return self::loadDao($daoMap[$index]);
		}
		$vkey .= '_' . $index;
		if (!isset(self::$_daoMaps[$vkey])) {
			$instance = null;
			foreach ($daoMap as $key => $value) {
				if ($index & $key) {
					$baseInstance = $instance;
					$instance = self::loadDao($value);
					if ($baseInstance) {
						$instance = clone $instance;
						$instance->setBaseInstance($baseInstance);
					}
				}
			}
			self::$_daoMaps[$vkey] = $instance;
		}
		return self::$_daoMaps[$vkey];
	}
}