<?php
/**
 * Windid工具库
 * 
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com> 2010-11-2
 * @license http://www.phpwind.com
 * @version $Id: WindidUtility.php 2109 2011-11-04 05:00:39Z xiaoxia.xuxx $
 * @package Windid.library
 */
class WindidUtility {
	/**
	 * 获得分页中的开始位置
	 *
	 * @param int $page 当前页面
	 * @param int $perpage 每页显示的条数
	 * @param int $total 总条数
	 * @return int
	 */
	static public function getStart($page, $perpage, $total = 0) {
		$page < 1 && $page = 1;
		$total > 0 && $page = min($page, ceil($total / $perpage));
		return ($page - 1) * $perpage;
	}
	
	/**
	 * 生成密码
	 *
	 * @param string $password 源密码
	 * @param string $salt
	 * @return string
	 */
	public static function buildPassword($password, $salt) {
		return md5(md5($password) . $salt);
	}
	
	/**
	 * 加密字符串
	 *
	 * @param string $string   需要加密or解密的字符串
	 * @param string $hash_key 加密的密钥信息
	 * @param boolean $encode  是否加密
	 * @return string
	 */
	static public function strcode($string, $hash_key, $encode = true) {
		!$encode && $string = base64_decode($string);
		$code = '';
		$key = substr(md5($_SERVER['HTTP_USER_AGENT'] . $hash_key), 8, 18);
		$keylen = strlen($key);
		$strlen = strlen($string);
		for ($i = 0; $i < $strlen; $i++) {
			$k = $i % $keylen;
			$code .= $string[$i] ^ $key[$k];
		}
		return $encode ? base64_encode($code) : $code;
	}
}