<?php

Wind::import('WIND:http.transfer.WindHttpSocket');
/**
 * 应用公共服务
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: WindidApp.php 2109 2011-11-04 05:00:39Z xiaoxia.xuxx $
 * @package windid.service.app
 */
class WindidApp {

	/**
	 * 获取应用列表
	 *
	 * @return array
	 */
	public function getList() {
		return $this->_getDao()->getList();
	}

	/**
	 * 获取单个应用
	 *
	 * @return array
	 */
	public function getAppById($id) {
		return $this->_getDao()->getAppById($id);
	}

	/**
	 * 添加一个应用
	 *
	 * @param WindidAppDm $dm 应用数据对象
	 * @return int 注册的应用id
	 */
	public function addApp(WindidAppDm $dm) {
		if (true !== ($check = $dm->beforeAdd())) return $check;
		$result = $this->_getDao()->addApp($dm->getData());
		$this->_resetNotify();
		return $result;
	}

	/**
	 * 删除一个应用
	 *
	 * @param int $id 应用id
	 * @return bool true|false
	 */
	public function delApp($id) {
		$result = $this->_getDao()->delApp($id);
		$this->_resetNotify();
		return $result;
	}

	/**
	 * 编辑应用信息
	 *
	 * @param int $id 应用id
	 * @param WindidAppDm $dm 应用信息
	 * @return bool true|false
	 */
	public function editApp($id, WindidAppDm $dm) {
		if (true !== ($check = $dm->beforeUpdate())) return $check;
		return $this->_getDao()->editApp($id, $dm->getData());
	}

	/**
	 * 获得应用Dao
	 * 
	 * @return WindidAppDao
	 */
	private function _getDao() {
		return Windid::loadDao('app.dao.WindidAppDao');
	}

	/**
	 * 设置通知信息
	 * 
	 */
	private function _resetNotify() {
		$applist = $this->getList();
		$notify = Windid::load('notify.WindidNotify');
		$appfields = array();
		foreach ($applist as $key => $value) {
			$appfields[] = $value['id'];
		}
		$notify->checkFields($appfields);
	}
}