<?php
/**
 * 应用数据访问层
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: WindidAppDao.php 10088 2012-05-16 12:18:26Z xiaoxia.xuxx $
 * @package windid.service.app.dao
 */
class WindidAppDao extends WindidBaseDao {

	protected $_table = 'windid_app';
	protected $_dataStruct = array('name', 'siteurl', 'secretkey', 'apifile', 'synlogin');

	/**
	 * 添加一个应用
	 *
	 * @param array $data 应用的数据
	 * @return int
	 */
	public function addApp($data) {
		if (!($clear = $this->_filterStruct($data))) return false;
		$sql = $this->_bindSql('INSERT INTO %s SET %s', $this->getTable(), $this->sqlSingle($clear));
		$this->getConnection()->execute($sql);
		return $this->lastInsertId();
	}

	/**
	 * 获得应用列表
	 *
	 * @return array
	 */
	public function getList() {
		$sql = $this->_bindTable('SELECT * FROM %s');
		return $this->getConnection()->query($sql)->fetchAll('id');
	}

	/**
	 * 获取单个应用
	 *
	 * @param int $id 应用ID
	 * @return array
	 */
	public function getAppById($id) {
		$id = intval($id);
		if ($id <= 0) return false;
		$sql = $this->_bindTable('SELECT * FROM %s WHERE id=?');
		return $this->getConnection()->createStatement($sql)->getOne(array($id));
	}
	
	/**
	 * 删除应用
	 *
	 * @param int $id 应用ID
	 * @return boolean
	 */
	public function delApp($id) {
		$id = intval($id);
		if ($id <= 0) return false;
		$sql = $this->_bindTable('DELETE FROM %s WHERE id=?');
		return $this->getConnection()->createStatement($sql)->update(array($id));
	}

	/**
	 * 编辑应用信息
	 *
	 * @param int $id 应用ID
	 * @param array $data 应用信息
	 * @return boolean
	 */
	public function editApp($id, $data) {
		if (!$id || !($clear = $this->_filterStruct($data))) return false;
		unset($clear['uid']);
		$sql = $this->_bindSql('UPDATE %s SET %s WHERE id=?', $this->getTable(), $this->sqlSingle($data));
		return $this->getConnection()->createStatement($sql)->update(array($id));
	}
}
