<?php

Wind::import('WINDID:library.base.WindidBaseDm');
/**
 * 应用的数据映射文件
 * 
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com> 2010-11-2
 * @license http://www.phpwind.com
 * @version $Id: WindidAppDm.php 3881 2012-01-16 08:11:58Z jieyin $
 * @package windid.service.app.dm
 */
class WindidAppDm extends WindidBaseDm {

	/**
	 * 返回appid
	 * 
	 * @return int $id
	 */
	public function getId() {
		return $this->_data['id'];
	}

	/**
	 * 返回app名字
	 * 
	 * @return string $name
	 */
	public function getName() {
		return $this->_data['name'];
	}

	/**
	 * 返回app路径
	 * 
	 * @return string $siteurl
	 */
	public function getSiteurl() {
		return $this->_data['siteurl'];
	}

	/**
	 * 返回应用私钥
	 * 
	 * @return string $secretkey
	 */
	public function getSecretkey() {
		return $this->_data['secretkey'];
	}

	/**
	 * 返回api文件
	 * 
	 * @return string $apifile
	 */
	public function getApifile() {
		return $this->_data['apifile'];
	}

	/**
	 * 返回是否同步登录
	 * 
	 * @return int $synlogin
	 */
	public function getSynlogin() {
		return $this->_data['synlogin'];
	}

	/**
	 * 设置appid
	 * 
	 * @param int $id
	 */
	public function setId($id) {
		$this->_data['id'] = intval($id);
	}

	/**
	 * 设置app名字
	 * 
	 * @param string $name
	 */
	public function setName($name) {
		$this->_data['name'] = $name;
	}

	/**
	 * 设置访问路径
	 * 
	 * @param string $siteurl
	 */
	public function setSiteurl($siteurl) {
		$this->_data['siteurl'] = $siteurl;
	}

	/**
	 * 设置应用私钥
	 * 
	 * @param string $secretkey
	 */
	public function setSecretkey($secretkey) {
		$this->_data['secretkey'] = $secretkey;
	}

	/**
	 * 设置链接访问的api文件
	 * 
	 * @param string $apifile
	 */
	public function setApifile($apifile) {
		$this->_data['apifile'] = $apifile;
	}

	/**
	 * 设置是否允许同步登录
	 * 
	 * @param int $synlogin
	 */
	public function setSynlogin($synlogin) {
		$this->_data['synlogin'] = intval($synlogin);
	}

	/* (non-PHPdoc)
	 * @see WindidBaseDm::beforeAdd()
	 */
	protected function _beforeAdd() {
		if (!isset($this->_data['name']) || !$this->_data['name']) return '应用名字不能为空';
		if (!isset($this->_data['siteurl']) || !$this->_data['siteurl']) return '应用链接不能为空';
		if (!isset($this->_data['secretkey']) || !$this->_data['secretkey']) return '应用安全链接码不能为空';
		return true;
	}

	/* (non-PHPdoc)
	 * @see WindidBaseDm::beforeUpdate()
	 */
	protected function _beforeUpdate() {
		return $this->beforeAdd();
	}
}