<?php
/**
 * 配置信息设置
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: WindidConfigSet.php 14853 2012-07-27 04:55:16Z xiaoxia.xuxx $
 * @package windid.config
 */
class WindidConfigSet {

	protected $_namespace = 'global';

	protected $_data = array();

	/**
	 * 构造函数
	 *
	 * @param string $namespace 名字空间
	 */
	public function __construct($namespace = null) {
		$namespace && $this->_namespace = $namespace;
	}

	/**
	 * 执行更新操作
	 *
	 * @return boolean
	 */
	public function execute() {
		if (!$this->_data) return false;
		$data = array();
		foreach ($this->_data as $key => $value) {
			$data[] = array('name' => $key, 'namespace' => $this->_namespace, 'value' => $value);
		}
		$data && $this->_getDao()->storeConfigs($data);
		$this->_data = array();
		return true;
	}

	/**
	 * 批量设置配置信息
	 *
	 * @param array $array 配置信息数组
	 * @return boolean
	 */
	public function setConfigs($array) {
		$this->_data = (array) $array;
		return $this->execute();
	}

	/**
	 * 设置配置信息
	 *
	 * @param string $name 配置项的名字
	 * @param string $value 配置项的值
	 * @param string $decrip 配置项的描述
	 * @return boolean
	 */
	public function setConfig($name, $value, $decrip = null) {
		return $this->_getDao()->storeConfig($this->_namespace, $name, $value, $decrip);
	}

	/**
	 * 删除配置信息
	 *
	 * @param string $name 配置项的名字
	 * @return boolean
	 */
	public function delete() {
		return $this->_getDao()->deleteConfig($this->_namespace);
	}

	/**
	 * 删除配置项
	 *
	 * @param string $name 配置项名字
	 * @return boolean
	 */
	public function deleteConfigByName($name = null) {
		return $this->_getDao()->deleteConfigByName($this->_namespace, $name);
	}
	
	/**
	 * 获得dao对象
	 * 
	 * @return WindidConfigDao
	 */
	private function _getDao() {
		return Windid::loadDao('config.dao.WindidConfigDao');
	}
}