<?php
Wind::import('WINDID:service.config.WindidConfigSet');

/**
 * 积分配置设置接口
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: WindidCreditSet.php 2649 2011-11-24 02:45:01Z xiaoxia.xuxx $
 * @package windid.config.bo
 */
class WindidCreditSet extends WindidConfigSet {

	protected $_namespace = 'credit';

	/**
	 * 批量设置
	 *
	 * @param array $array 积分配置信息<array('1' => array('name'=>?,'unit'=>?,'descrip'=>?), '2' => ?, ...)>
	 * @return boolean
	 */
	public function setConfigs($array) {
		if (!is_array($array)) return false;
		$this->delete();
		foreach ($array as $key => $value) {
			if (!$this->_isLegal($key)) continue;
			$this->_data[$key . '.name'] = $value['name'];
			$this->_data[$key . '.unit'] = $value['unit'];
			$this->_data[$key . '.descrip'] = $value['descrip'];
		}
		return $this->execute();
	}

	/**
	 * 单个设置
	 *
	 * @param int $id 积分id
	 * @param string $name 积分名
	 * @param string $unit 积分单位
	 * @param string $descrip 描述
	 * @return boolean
	 */
	public function set($id, $name, $unit, $descrip = null) {
		if (!$this->_isLegal($id)) return false;
		$this->setConfig($id . '.name', $name);
		$this->setConfig($id . '.unit', $unit);
		$descrip && $this->setConfig($id . '.descrip', $descrip);
		return true;
	}

	/**
	 * 检查是否是合理的key
	 *
	 * @param string $key 积分号
	 * @return boolean
	 */
	private function _isLegal(&$key) {
		$key = intval($key);
		return $key >= 1 && $key <= 8;
	}
}