<?php
Wind::import('WINDID:service.config.WindidConfigSet');

/**
 * 邮件配置设置接口
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: WindidMailSet.php 2109 2011-11-04 05:00:39Z xiaoxia.xuxx $
 * @package windid.config.bo
 */
class WindidMailSet extends WindidConfigSet {

	protected $_namespace = 'mail';

	/**
	 * 设置SMTP服务器
	 *
	 * @param string $host SMTP服务器
	 */
	public function setHost($host) {
		$this->_data['host'] = $host;
	}

	/**
	 * 设置SMTP端口
	 *
	 * @param int $port SMTP端口
	 */
	public function setPort($port) {
		$this->_data['port'] = $port;
	}

	/**
	 * 设置发信人地址
	 *
	 * @param string $sendmail 发信人地址
	 */
	public function setSendmail($sendmail) {
		$this->_data['sendmail'] = $sendmail;
	}

	/**
	 * 设置是否需要用户身份验证
	 *
	 * @param int $isauth 验证方式<0.不需要 1.需要>
	 */
	public function setIsAuth($isauth) {
		$this->_data['isauth'] = intval($isauth);
	}

	/**
	 * 设置验证用户名
	 *
	 * @param string $username 用户名
	 */
	public function setUser($username) {
		$this->_data['user'] = $username;
	}

	/**
	 * 设置验证密码
	 *
	 * @param string $password 密码
	 */
	public function setPassword($password) {
		$this->_data['password'] = $password;
	}
}