<?php
Wind::import('WINDID:service.config.WindidConfigSet');

/**
 * 注册配置设置接口
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: WindidRegisterSet.php 2109 2011-11-04 05:00:39Z xiaoxia.xuxx $
 * @package windid.config.bo
 */
class WindidRegisterSet extends WindidConfigSet {

	protected $_namespace = 'reg';

	/**
	 * 设置用户名长度限制
	 *
	 * @param int $min 最短限制
	 * @param int $max 最长限制
	 */
	public function setNameLength($min, $max) {
		$this->_data['namelength.min'] = intval($min);
		$this->_data['namelength.max'] = intval($max);
	}

	/**
	 * 用户名是否允许用户大写字符
	 *
	 * @param bool $allow true|false
	 */
	public function setNameAllowUpper($allow) {
		$this->_data['nameallowupper'] = $allow ? 1 : 0;
	}

	/**
	 * 设置禁止使用的用户列表
	 *
	 * @param array $names 用户名列表<例:array('username1', 'username2')>
	 */
	public function setForbiddenName($names) {
		$this->_data['forbiddenname'] = (array) $names;
	}

	/**
	 * 设置邮箱有效性验证方式
	 *
	 * @param int $type 验证方式<0.不验证 1.白名单 2.黑名单>
	 */
	public function setEmailVerifyType($type) {
		$this->_data['emailverifytype'] = intval($type);
	}

	/**
	 * 设置邮箱白名单
	 *
	 * @param array $whitelist 白名单列表<例:array('163.com', 'gmail.com')>
	 */
	public function setEmailWhiteList($whitelist) {
		$this->_data['emailwhitelist'] = (array) $whitelist;
	}

	/**
	 * 设置邮箱黑名单
	 *
	 * @param array $blacklist 黑名单列表<例:array('163.com', 'gmail.com')>
	 */
	public function setEmailBlackList($blacklist) {
		$this->_data['emailblacklist'] = (array) $blacklist;
	}

	/**
	 * 设置密码长度限制
	 *
	 * @param int $min 最短限制
	 * @param int $max 最长限制
	 */
	public function setPasswordLength($min, $max) {
		$this->_data['passwordlength.min'] = intval($min);
		$this->_data['passwordlength.max'] = intval($max);
	}
}