<?php

Wind::import('WINDID:service.config.dm.WindidConfigDm');

/**
 * 积分配置设置接口
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: WindidConfigCreditDm.php 14853 2012-07-27 04:55:16Z xiaoxia.xuxx $
 * @package windid.config.bo
 */
class WindidConfigCreditDm extends WindidConfigDm {

	public $namespace = 'credit';

	/**
	 * 批量设置
	 *
	 * @param array $array 积分配置信息<array('1' => array('name'=>?,'unit'=>?,'descrip'=>?), '2' => ?, ...)>
	 * @return boolean
	 */
	public function setConfigs($array) {
		if (!is_array($array)) return;
		foreach ($array as $key => $value) {
			$this->set($key, $value['name'], $value['unit'], $value['descrip']);
		}
	}

	/**
	 * 单个设置
	 *
	 * @param int $id 积分id
	 * @param string $name 积分名
	 * @param string $unit 积分单位
	 * @param string $descrip 描述
	 * @return boolean
	 */
	public function set($id, $name, $unit, $descrip = null) {
		if (!$this->_isLegal($id)) return false;
		$this->_data[$id . '.name'] = $name;
		$this->_data[$id . '.unit'] = $unit;
		$descrip && $this->_data[$id . '.descrip'] = $descrip;
		return true;
	}

	/**
	 * 检查是否是合理的key
	 *
	 * @param string $key 积分号
	 * @return boolean
	 */
	private function _isLegal(&$key) {
		$key = intval($key);
		return $key >= 1;
	}

	protected function _beforeAdd() {
		return true;
	}

	protected function _beforeUpdate() {
		Windid::load('config.WindidConfig')->deleteConfig($this->namespace);
		return true;
	}
}