<?php

/**
 * 消息基础表
 *
 * @author peihong.zhang
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwMessageMessagesDao.php 3575 2012-01-11 11:32:47Z zhangph $
 * @package forum
 */

class WindidMessageDao extends WindidBaseDao {
	
	protected $_table = 'windid_message';
	protected $_dataStruct = array('message_id', 'from_uid', 'content', 'created_time');
	
	/**
	 * 获取单条消息
	 * 
	 * @param int $id
	 * @return array 
	 */
	public function getMessage($id) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE message_id=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($id));
	}

	/**
	 * 添加单条消息
	 * 
	 * @param array $fields
	 * @return bool 
	 */
	public function addMessage($fields) {
		if (!$fields = $this->_filterStruct($fields)) {
			return false;
		}
		$sql = $this->_bindSql('INSERT INTO %s SET %s ', $this->getTable(), $this->sqlSingle($fields));
		$this->getConnection()->execute($sql);
		return $this->getConnection()->lastInsertId();
	}
	
	/**
	 * 删除单条消息
	 * 
	 * @param int $id
	 * @return bool 
	 */
	public function deleteMessage($id) {
		$sql = $this->_bindTable('DELETE FROM %s  WHERE message_id=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array($id));
	}
	
	/**
	 * 删除多条消息
	 * 
	 * @param array $ids
	 * @return bool 
	 */
	public function deleteMessages($ids) {
		$sql = $this->_bindSql('DELETE FROM %s WHERE `message_id` IN %s ', $this->getTable(), $this->sqlImplode($ids));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->update(array());
	}
	
	/**
	 * 根据Ids获取消息
	 * 
	 * @param array $ids
	 * @return array 
	 */
	public function getMessagesByIds($ids) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE `message_id` IN %s ', $this->getTable(), $this->sqlImplode($ids));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array(),'message_id');
	}
	
	/**
	 * 搜索消息数量
	 * 
	 * @param int $from_uid
	 * @param int $starttime
	 * @param int $endtime
	 * @return array 
	 */
	public function countMessageByUid($from_uid,$keyword,$starttime,$endtime) {
		$where = 'WHERE 1';
		$param = array();
		if ($from_uid !== NULL) {
			$where .= ' AND `from_uid` =? ';
			$param[] = $from_uid;
		}
		if ($keyword) {
			$where .= ' AND `content` LIKE ?';
			$param[] = '%'.$keyword.'%';
		}
		if ($starttime) {
			$where .= ' AND `created_time` >=?';
			$param[] = $starttime;
		}	
		if ($endtime) {
			$where .= ' AND `created_time` <=?';
			$param[] = $endtime;
		}
		$sql = $this->_bindSql('SELECT COUNT(*) FROM %s %s', $this->getTable(), $where);
		
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue($param);
	}
	
	/**
	 * 搜索消息
	 * 
	 * @param int $start
	 * @param int $limit
	 * @param int $from_uid
	 * @param int $starttime
	 * @param int $endtime
	 * @return array 
	 */
	public function getMessagesByUid($start,$limit,$from_uid,$keyword,$starttime,$endtime) {
		$where = 'WHERE 1';
		$param = array();
		if ($from_uid !== NULL) {
			$where .= ' AND `from_uid` =? ';
			$param[] = $from_uid;
		}
		if ($keyword) {
			$where .= ' AND `content` LIKE ?';
			$param[] = '%'.$keyword.'%';
		}
		if ($starttime) {
			$where .= ' AND `created_time` >=?';
			$param[] = $starttime;
		}	
		if ($endtime) {
			$where .= ' AND `created_time` <=?';
			$param[] = $endtime;
		}
		$sql = $this->_bindSql('SELECT * FROM %s %s ORDER BY created_time DESC ' . $this->sqlLimit($limit, $start), $this->getTable(), $where);
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll($param);
	}
}