<?php

Wind::import('WINDID:service.message.dm.WindidMessageDm');
/**
 * 私信业务
 *
 * @author peihong <peihong.zhangph@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: WindidMessageService.php 3833 2012-01-12 03:32:27Z peihong.zhangph $
 * @package windid.service.message.srv
 */
class WindidMessageService {
	
	const USER_NOT_EXISTS = 1;
	
	static private $_blackList = array();
	/**
	 * 
	 * 发送私信
	 * @param string $username
	 * @param string $content
	 * @param int $fromUid
	 */
	public function sendMessage($username,$content,$fromUid){
		$userInfo = $this->_getUserDs()->getUserByName($username);
		if (!$userInfo) return new WindidError(self::USER_NOT_EXISTS);
		return $this->sendMessageByUid($userInfo['uid'], $content,$fromUid);
	}
	
	/**
	 * 按用户ID发送私信
	 * 
	 * @param int $uid
	 * @param string $content
	 * @param int $fromUid
	 * @return WindidError|boolean
	 */
	public function sendMessageByUid($uid,$content,$fromUid = 0){
		if (!$uid || !$fromUid) return false;
		if (!$this->_blackList[$uid]) {
			$this->_blackList[$uid] = $this->_getUserBlack()->getBlacklist($uid);
		}
		//生成新消息
		$dm = new WindidMessageDm();
		$dm->setCreatedUserId($fromUid)->setContent($content);
		if (($result = $dm->beforeAdd()) instanceof WindidError) return $result;
		$messageId = $this->_getMessageDs()->addMessage($dm);
		$lastMessage = $this->_getLastMessage($fromUid,$uid, $content);
		
		//=========================发件人对话信息=========================
		$dm = new WindidMessageDm();
		$dm->setLastMessage($lastMessage);
		
		$dialog = $this->_getMessageDs()->getDialogByUid($fromUid,$uid);
		if ($dialog) {
			$dialogId = $dialog['dialog_id'];
			$dm->increaseMessageCount()->setModifiedTime(Pw::getTime());
			$this->_getMessageDs()->updateDialog($dialogId,$dm);
		} else {
			$dm->setToUid($fromUid)
				->setFromUid($uid)
				->setMessageCount(1);
			$dialogId = $this->_getMessageDs()->addDialog($dm);
		}
		
		//添加发件人联系
		$dm = new WindidMessageDm();
		$dm->setDialogId($dialogId)->setMessageId($messageId);
		$this->_getMessageDs()->addRelation($dm);
			
		$dm = new WindidMessageDm();
		$dm->setLastMessage($lastMessage);
		if (in_array($fromUid, $this->_blackList[$uid])) {
			return false;
		}
		
		//=========================收件人对话信息=========================
		$dialog = $this->_getMessageDs()->getDialogByUid($uid,$fromUid);
		// 分组已存在更新数量
		if ($dialog) {
			$dialogId = $dialog['dialog_id'];
			$dm->increaseUnreadCount()->increaseMessageCount()->setModifiedTime(Pw::getTime());
			$this->_getMessageDs()->updateDialog($dialogId,$dm);
		} else { 
			// 分组不存在添加一条
			$dm->setToUid($uid)
				->setFromUid($fromUid)
				->setUnreadCount(1)
				->setMessageCount(1);
			//新增私信分组记录
			$dialogId = $this->_getMessageDs()->addDialog($dm);
		}
		
		//添加收件人联系
		$dm = new WindidMessageDm();
		$dm->setDialogId($dialogId)->setMessageId($messageId);
		$this->_getMessageDs()->addRelation($dm);
		
		return true;
	}
	
	/**
	 * 按用户名群发送私信
	 * 
	 * @param array $usernames
	 * @param content $content
	 * @param int $from_uid
	 * @return PwError|boolean
	 */
	public function sendMessageByUsernames($usernames,$content,$from_uid = 0){
		$userInfos = $this->_getUserDs()->fetchUserByName($usernames);
		if (!$userInfos) {
			return new WindidError('MESSAGE:user.notfound');
		}
		foreach ($userInfos as $userInfo) {
			$this->sendMessageByUid($userInfo['uid'],$content,$from_uid);
		}
		return true;
	}
	
	/**
	 * 根据uids群发消息
	 * 
	 * @param array $uids
	 * @param string $content
	 * @param int $from_uid
	 * @return PwError|boolean
	 */
	public function sendMessageByUids($uids,$content,$from_uid = 0){
		if (!$content) {
			return new WindidError('MESSAGE:content.empty');
		}
		
		$userInfos = $this->_getUserDs()->fetchUserByUid($uids);
		if (!$userInfos) {
			return new WindidError('MESSAGE:user.notfound');
		}
		foreach ($userInfos as $userInfo) {
			$this->sendMessageByUid($userInfo['uid'],$content,$from_uid);
		}
		return true;
	}
	
	/**
	 * 
	 * 获取分组列表
	 * 
	 * @param int $uid
	 * @param int $start
	 * @param int $limit
	 * @return array 
	 */
	public function getDialogs($uid,$start,$limit){
		// 分组消息分页
		$count = $this->_getMessageDs()->countDialogs($uid);
		if ($count < 1) return array(0,array());
		
		$dialogs = $this->_getMessageDs()->getDialogs($uid,$start,$limit);
		foreach ($dialogs as $k=>$v) {
			$v['last_message'] && $v['last_message'] = @unserialize($v['last_message']);
			$dialogs[$k] = $v;
		}
		return array($count,$dialogs);
	}
	
	public function deleteUserMessages($uid){
		$dialogIds = $this->_getMessageDs()->getDialogIds($uid);
		$dialogIds && $this->batchDeleteDialog($dialogIds);
		Wind::import('SRV:user.dm.PwUserInfoDm');
		$user = Wekit::load('user.PwUser');
		$dm = new PwUserInfoDm($uid);
		$dm->setMessageCount(0);
		$user->editUser($dm, PwUser::FETCH_DATA);
		return true;
	}
	
	public function getDialogMessage($dialogId,$messageId){
		return $this->_getMessageDs()->getDialogMessages($dialogId,$messageId);
	}
	
	/**
	 * 获取对话消息列表
	 *
	 * @param int $dialogId
	 * @param int $start
	 * @param int $limit
	 * @return array
	 */
	public function getDialogMessages($dialogId,$limit,$start) {
		// 对话消息分页
		list($count) = $this->_getMessageDs()->countDialogMessages($dialogId);
		if ($count < 1) return array(0,array());
		$messages = $this->_getMessageDs()->getDialogMessages($dialogId,$limit,$start);
		$uids = array();
		foreach ($messages as $v) {
			$uids[$v['from_uid']] = $v['from_uid'];
		}
		if ($uids) {
			$users = $this->_getUserDs()->fetchUserByUid($uids);
			foreach ($messages as $k=>$v) {
				$messages[$k]['from_username'] = $users[$v['from_uid']]['username'];
			}
		}
		return array($count,$messages);
	}
	
	/**
	 * 
	 * 删除会话
	 * @param array $dialogIds
	 */
	public function batchDeleteDialog($dialogIds){
		if (!is_array($dialogIds) || !$dialogIds) return false;
		$data = array();
		$dialogs = $this->_getMessageDs()->fetchDialogByDialogIds($dialogIds);
		foreach ($dialogs as $dialog) {
			$uid = $dialog['to_uid'];
			$data[$uid]['dialogIds'][] = $dialog['dialog_id'];
			//$data[$uid]['unreads'] += $dialog['unread_count'];
		}
		if (!$data) return true;
		foreach ($data as $uid => $v) {
			//$v['unreads'] && $this->updateUserUnreadNum($uid,$v['unreads']);//TODO
			if (!$v['dialogIds']) continue;
			$this->_getMessageDs()->batchDeleteRelationByDialogIds($v['dialogIds']);
			$this->_getMessageDs()->batchDeleteDialog($v['dialogIds']);
		}
		return true;
	}
	
	/**
	 * 搜索消息前后对话内容
	 * 
	 * @param int $uid
	 * @param int $fromUid
	 * @param int $messageId
	 * @param int $num
	 * @return array 
	
	public function seekMessages($uid,$fromUid,$messageId,$num) {
		return $this->_getMessageDs()->seekMessages($uid,$fromUid,$messageId,$num);
	}
	*/
	
	/**
	 * 搜索消息
	 * 
	 * @param int $start
	 * @param int $limit
	 * @param int $uid
	 * @param string $keyword
	 * @param int $from_uid
	 * @param int $starttime
	 * @param int $endtime
	 * @return array 
	 */
	public function getMessagesByUidAndKeyword($start,$limit,$uid = null,$keyword = null,$username = null,$starttime = null,$endtime = null) {
		$username && $userinfo = $this->_getUserDs()->getUserByName($username);
		$count = $this->_getMessageDs()->countMessageByUidAndKeyword($uid,$keyword,$userinfo['uid'],$starttime,$endtime);
		if ($count < 1) return array(0,array());
		$messages = $this->_getMessageDs()->getMessagesByUidAndKeyword($start,$limit,$uid,$keyword,$userinfo['uid'],$starttime,$endtime);
		$uids = $array = array();
		foreach ($messages as $v) {
			$uids[] = $v['from_uid'];
		}
		// 组装用户数据
		$userInfos = $this->_getUserDs()->fetchUserByUid($uids);
		if (!$userInfos) return array(0,array());
		foreach ($messages as $v) {
			$v['username'] = $userInfos[$v['from_uid']]['username'];
			if ($v['from_uid'] == $uid) {
				$v['username'] = '我';
			}
			$array[] = $v;
		}
		return array($count,$array);
	}
	
	/**
	 * 
	 * 添加用户黑名单
	 * @param int $uid
	 * @param int $blackUid
	 */
	public function addBlackUser($uid,$blackUid){
		$uid = intval($uid);
		$blackUid = intval($blackUid);
		if ($uid < 1 || $blackUid < 1) return false;
		$blackList = $this->_getUserBlack()->getBlacklist($uid);
		if (in_array($blackUid, $blackList)) {
			return true;
		}
		$blackList[] = $blackUid;
		return $this->_getUserBlack()->setBlacklist($uid, $blackList);
	}
	
	/**
	 * 
	 * 重新统计某会话的统计数
	 * @param int $dialogId
	 */
	public function resetDialogMessages($dialogId){
		list($messages,$reads) = $this->_getMessageDs()->countDialogMessages($dialogId);
		$unreads = $reads > $messages ? 0 : $messages - $reads;
		$dm = new WindidMessageDm();
		$dm->setMessageCount($messages);
		$dm->setUnreadCount($unreads);
		$this->_getMessageDs()->updateDialog($dialogId, $dm);
	}
	
	/**
	 * 
	 * 组装最近一条消息的信息
	 * @param int $fromUid
	 * @param int $toUid
	 * @param string $messageContent
	 */
	private function _getLastMessage($fromUid,$toUid,$messageContent){
		$lastMessage = array();
		$userInfos = $this->_getUserDs()->fetchUserByUid(array($fromUid,$toUid));
		if (!$userInfos) return $lastMessage;
		$lastMessage['from_uid'] = $fromUid;
		$lastMessage['from_username'] = $userInfos[$fromUid]['username'];
		$lastMessage['to_uid'] = $toUid;
		$lastMessage['to_username'] = $userInfos[$toUid]['username'];
		$lastMessage['content'] = $messageContent;
		return $lastMessage;
	}
	
	/**
	 * 
	 * @return WindidMessage
	 */
	private function _getMessageDs(){
		return Windid::load('message.WindidMessage');
	}
	
	/**
	 * 
	 * @return WindidUser
	 */
	private function _getUserDs(){
		return Windid::load('user.WindidUser');
	}
	
	/** 
	 * 获得PwUserBlack DS
	 *
	 * @return PwUserBlack
	 */
	private function _getUserBlack() {
		return Wekit::load('user.PwUserBlack');
	}
}