<?php

/**
 * 通知队列服务..
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: WindidNotify.php 2117 2011-11-04 07:45:21Z jieyin $
 * @package windid.notify
 */
class WindidNotify {

	/**
	 * 根据通知id获得通知数据
	 *
	 * @param int $nid 通知id
	 * @return array|false
	 */
	public function getById($nid) {
		return $this->_getDao()->getById($nid);
	}

	/**
	 * 根据appid获得消息信息
	 *
	 * @param int $appid 
	 * @return array|false
	 */
	public function getOneByAppId($appid) {
		return $this->_getDao()->getOne($appid);
	}

	/**
	 * 添加数据
	 *
	 * @param string $operation 操作名称
	 * @param array 操作数据
	 * @param array 应用id
	 * @return int 
	 */
	public function add($operation, $params = array(), $appids = array()) {
		$tmp = array('operation' => $operation, 'param' => ($params && is_array($params)) ? serialize($params) : '', 
			'timestamp' => TIMESTAMP, 'complete' => 0);
		return $this->_getDao()->insert(array_merge($tmp, $appids));
	}
	
	/**
	 * 更新数据
	 *
	 * @param int $nid 通知id
	 * @param array $appids 应用id
	 * @param int $complete 是否已经完成发送
	 * @return int 
	 */
	public function updateByNid($nid, $appids = array(), $complete = 1) {
		$appids = $this->_filterIds($appids);
		$appids['complete'] = intval($complete);
		return $this->_getDao()->update($nid, $appids);
	}
	
	/**
	 * 根据信息删除一条数据
	 *
	 * @param int|array 应用id
	 * @return int 
	 */
	public function delByNid($nid) {
		if (!($ids = $this->_filterIds($nid)));
		return $this->_getDao()->delByNid($ids);
	}

	/**
	 * 检查appid字段
	 *
	 * @param array $appfields appid集合
	 * @return boolean
	 */
	public function checkFields($appfields) {
		return $this->_getDao()->checkFields($appfields);
	}
	
	/**
	 * 过滤所有的int类型的id列表
	 *
	 * @param array $ids id列表
	 * @return array
	 */
	private function _filterIds($ids) {
		!is_array($ids) && $ids = array($ids);
		$clear = array();
		foreach ($ids as $id) {
			if (false === WindValidator::isPositive($id)) continue;
			$clear[] = $id;
		}
		return $clear;
	}

	/**
	 * 获得通知dao
	 * 
	 * @return WindidNotifyDao
	 */
	private function _getDao() {
		return Windid::loadDao('notify.dao.WindidNotifyDao');
	}
}        