<?php

/**
 * 通知队列数据访问层
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: WindidNotifyDao.php 10088 2012-05-16 12:18:26Z xiaoxia.xuxx $
 * @package windid.service.notify.dao
 */
class WindidNotifyDao extends WindidBaseDao {

	protected $_table = 'windid_notify';

	/**
	 * 根据ID获取信息
	 *
	 * @param int $nid
	 * @return array|boolean
	 */
	public function getById($nid) {
		$nid = intval($nid);
		if ($nid <= 0) return false;
		$sql = $this->_bindTable('SELECT * FROM %s WHERE nid=?');
		return $this->getConnection()->createStatement($sql)->getOne(array($nid));
	}
	
	/**
	 * 根据应用ID获取信息
	 *
	 * @param int $appid 应用ID
	 * @return array|false
	 */
	public function getOne($appid) {
		$appid = intval($appid);
		if ($appid <= 0) return false;
		$field = 'app' . intval($appid);
		$sql = $this->_bindSql('SELECT * FROM %s WHERE %s=0 ORDER BY nid ASC LIMIT 1', $this->getTable(), $field);
		return $this->getConnection()->query($sql)->fetch();
	}

	/**
	 * 插入数据
	 *
	 * @param array $data 插入信息数据
	 * @return int
	 */
	public function insert($data) {
		if (!($clear = $this->_filterStruct($data))) return false;
		$sql = $this->_bindSql('INSERT INTO %s SET %s', $this->getTable(), $this->sqlSingle($clear));
		$this->getConnection()->execute($sql);
		return $this->lastInsertId();
	}
	
	/**
	 * 删除数据
	 *
	 * @param int|array $nid 消息ID
	 * @return boolean
	 */
	public function delByNid($nid) {
		if (!is_array($nid)) {
			$nid = intval($nid);
			if ($nid <= 0) return false;
			$nid = (array)$nid;
		}
		$sql = $this->_bindSql('DELETE FROM %s WHERE nid IN %s', $this->getTable(), $this->sqlImplode($nid));
		return $this->getConnection()->execute($sql);
	}

	/**
	 * 更新数据
	 *
	 * @param int $nid 信息id
	 * @param array $data 信息数据
	 */
	public function update($nid, $data) {
		$nid = intval($nid);
		if ($nid <= 0 || !($clear = $this->_filterStruct($data))) return false;
		$sql = $this->_bindSql('UPDATE %s SET %s WHERE nid=?', $this->getTable(), $this->sqlSingle($clear));
		return $this->getConnection()->createStatement($sql)->update(array($nid));
	}

	/**
	 * 检查字段
	 *
	 * @param array $appfields appID集合
	 * @return boolean
	 */
	public function checkFields($appfields) {
		$col = array();
		$arr = $this->query($this->_bindTable("SHOW COLUMNS FROM %s LIKE 'app%'"))->fetchAll();
		foreach ($arr as $key => $value) {
			$col[] = intval(substr($value['Field'], 3));
		}
		if ($addcol = array_diff($appfields, $col)) {
			$sql = '';
			foreach ($addcol as $v) {
				$sql .= "ADD app{$v} TINYINT(1) NOT NULL default 0,";
			}
			$this->_update($this->_bindSql('ALITER TABLE %s %s', $this->getTable(), rtrim($sql, ',')));
		}
		if ($delcol = array_diff($col, $appfields)) {
			$sql = '';
			foreach ($delcol as $v) {
				$sql .= "DROP app{$v},";
			}
			$sql = $this->_bindSql('ALTER TABLE %s %s', $this->getTable(), rtrim($sql, ','));
			return $this->getConnection()->execute($sql);
		}
		return true;
	}
}