<?php

/**
 * 通知队列服务..
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: WindidNotifyService.php 2109 2011-11-04 05:00:39Z xiaoxia.xuxx $
 * @package windid.service.notify.srv
 */
class WindidNotifyService {
	
	protected $_queue = array();
	protected $_operations = array('updatesyncredit' => '', 'syncredit' => '', 'altername' => '', 
		'deleteUser' => 'user.deleteUser');

	/**
	 * 添加一条删除用户的通知信息
	 *
	 * @param int $uid 用户ID
	 * @return int
	 */
	public function addDelUserNotify($uid) {
		return $this->add('deleteUser', array('uid' => $uid));
	}

	/**
	 * 添加一条数据
	 *
	 * @param string $operation 操作
	 * @param array $params 操作参数
	 * @param boolean $exceptself 是否算上自己，默认为false
	 * @return int
	 */
	public function add($operation, $params = array(), $exceptself = false) {
		$notify = $data = array();
		$applist = $this->_getAppService()->getList();
		foreach ($applist as $key => $value) {
			if ($exceptself && $value['id'] == WINDID_APPID) {
				$data['app' . $value['id']] = 1;
			} else {
				$notify['notifyexists' . $value['id']] = 1;
			}
		}
		$nid = $this->_getDS()->add($operation, $params, $data);
		if ($notify) $this->_getConfigSet()->setConfigs($notify);
		return $nid;
	}

	/**
	 * 设置发送队列是否已经发送
	 *
	 * @param int $nid 消息id
	 * @return true
	 */
	public function sendQueue($nid = 0) {
		$this->_queue[$nid] = 1;
		return true;
	}

	/**
	 * 发送通知队列
	 */
	private function _send() {
		foreach ($this->_queue as $key => $value) {
			$this->send($key);
		}
	}

	/**
	 * 发送通知
	 *
	 * @param int $nid  通知id
	 * @param int $appid 应用ID
	 * @return boolean
	 */
	public function send($nid, $appid) {
		$appService = $this->_getAppService();
		if (!$app = $appService->getAppById($appid)) return false;
		$data = $nid ? $this->_getDS()->getById($nid) : $this->_getDS()->getOneByAppId($appid);
		
		if (empty($data)) {
			$nid || $this->_getConfigSet()->setConfig('notifyexists' . $appid, 0);
			return false;
		}
		
		$nid = $data['nid'];
		$param = $data['param'] ? unserialize($data['param']) : array();
		
		if ($appid == WINDID_APPID) {
			try {
				$class = $this->_getApiService();
				$result = $class->callback($this->_operations[$data['operation']], $param);
				$success = 1;
			} catch (Exception $e) {
				$success = 0;
			}
		} else {
			$result = $appService->send($app['siteurl'], $app['apifile'], $app['secretkey'], $this->_operations[$data['operation']], $param);
			$success = isset($result['result']);
		}
		if (!$success) return false;
		
		$field = 'app' . $appid;
		$data[$field] = 1;
		$this->_getDS()->updateByNid($nid, array($field => 1), $this->isComplete($data, $appService->getList()) ? 1 : 0);
		return true;
	}
	
	/**
	 * 检查通知是否已经完成
	 *
	 * @param array $notify 通知队列
	 * @param array $apps 需要检查的appid
	 * @return boolean
	 */
	public function isComplete($notify, $apps) {
		foreach ($apps as $key => $app) {
			if ($notify['app' . $key] < 1) return false;
		}
		return true;
	}

	/**
	 * 析构函数
	 * 
	 * 发送队列数据
	 */
	public function __destruct() {
		if (!empty($this->_queue)) {
			$this->_send();
		}
	}
	
	/**
	 * 获得通知dao
	 * 
	 * @return WindidNotify
	 */
	private function _getDS() {
		return Windid::load('notify.WindidNotify');
	}

	/**
	 * 获得应用app
	 * 
	 * @return WindidAppService
	 */
	private function _getAppService() {
		return Windid::load('app.srv.WindidAppService');
	}

	/**
	 * 获得配置DS
	 * 
	 * @return WindidConfigSet
	 */
	private function _getConfigSet() {
		return Windid::load('config.WindidConfigSet');
	}

	/**
	 * 获得api服务对象
	 *
	 */
	private function _getApiService() {
		static $api = null;
		if ($api == null) {
			$class = Wind::import('WINDID:api.WindidApi');
			$api = new $class();
		}
		return $api;
	}
}        