<?php

/**
 * 用户黑名单
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package wind
 */
class WindidUserBlack {
	
	/**
	 * 获取用户黑名单
	 * 
	 * @param int $uid
	 * @return array
	 */
	public function getBlacklist($uid){
		$blacklist = array();
		$uid = intval($uid);
		if ($uid < 1) return $blacklist;
		$rs = $this->_getBlacklistDao()->getBlacklist($uid);
		if ($rs['blacklist']) {
			$blacklist = @unserialize($rs['blacklist']);
		}
		return $blacklist;
	}
	
	/**
	 * 批量获取用户黑名单
	 * 
	 * @param array $uids
	 * @return array
	 */
	public function fetchBlacklist($uids){
		if (!is_array($uids) || !count($uids)) {
			return array();
		}
		return $this->_getBlacklistDao()->fetchBlacklist($uids);
	}
	
	/**
	 * 设置用户黑名单
	 * 
	 * @param int $uid
	 * @param array $blacklist (username)
	 */
	public function setBlacklist($uid,$blacklist){
		$uid = intval($uid);
		if ($uid < 1 || !is_array($blacklist)) return false;
		return $this->_getBlacklistDao()->replaceBlacklist(array('uid' => $uid, 'blacklist' => serialize($blacklist)));
	}
	
	/**
	 * 删除
	 * 
	 * @param int $uid
	 * @return bool 
	 */
	public function deleteBlacklist($uid) {
		$uid = intval($uid);
		if ($uid < 1) return false;
		return $this->_getBlacklistDao()->deleteBlacklist($uid);
	}
	
	/**
	 * @return WindidUserBlackDao
	 */
	protected function _getBlacklistDao() {
		return Windid::loadDao('user.dao.WindidUserBlackDao');
	}
}