<?php

Wind::import('WINDID:service.user.dao.WindidUserInterface');

/**
 * 用户积分基本信息数据访问层
 * 
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: WindidUserDao.php 6765 2012-03-23 08:03:03Z liusanbian $
 * @package windid.service.user.dao
 */
class WindidUserDao extends WindidBaseDao implements WindidUserInterface {

	protected $_table = 'windid_user';
	protected $_pk = 'uid';
	protected $_dataStruct = array('uid', 'username', 'email', 'password', 'salt', 'safecv', 'regdate', 'regip');

	/* (non-PHPdoc)
	 * @see WindidUserInterface::getUserByUid()
	 */
	public function getUserByUid($uid) {
		return $this->_get($uid);
	}

	/* (non-PHPdoc)
	 * @see WindidUserInterface::getUserByName()
	 */
	public function getUserByName($username) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE username=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($username));
	}

	/* (non-PHPdoc)
	 * @see WindidUserInterface::getUserByEmail()
	 */
	public function getUserByEmail($email) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE email=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array($email));
	}

	/* (non-PHPdoc)
	 * @see WindidUserInterface::getUsersByUids()
	 */
	public function fetchUserByUid($uids) {
		return $this->_fetch($uids, 'uid');
	}

	/* (non-PHPdoc)
	 * @see WindidUserInterface::getUsersByNames()
	 */
	public function fetchUserByName($usernames) {
		$sql = $this->_bindSql('SELECT * FROM %s WHERE username IN %s', $this->getTable(), $this->sqlImplode($usernames));
		$rst = $this->getConnection()->query($sql);
		return $rst->fetchAll('uid');
	}

	/* (non-PHPdoc)
	 * @see WindidUserInterface::addUser()
	 */
	public function addUser($fields) {
		return $this->_add($fields);
	}

	/* (non-PHPdoc)
	 * @see WindidUserInterface::deleteUser()
	 */
	public function deleteUser($uid) {
		return $this->_delete($uid);
	}
	
	/* (non-PHPdoc)
	 * @see WindidUserInterface::batchDeleteUser()
	 */
	public function batchDeleteUser($uids) {
		return $this->_batchDelete($uids);
	}

	/* (non-PHPdoc)
	 * @see WindidUserInterface::editUser()
	 */
	public function editUser($uid, $fields, $increaseFields = array()) {
		return $this->_update($uid, $fields);
	}

	/**
	 * 检查email是否存在
	 *
	 * @param string $email    用户的email
	 * @param string $username 用户名字
	 * @return array
	 */
	public function checkEmailExists($email, $username = '') {
		$sql = 'SELECT COUNT(*) AS sum FROM %s WHERE email=?';
		$arg = array($email);
		if ($username) {
			$sql = 'SELECT COUNT(*) AS sum FROM %s WHERE email=? AND username <> ?';
			$arg[] = $username;
		}
		$sql = $this->_bindTable($sql);
		$smt = $this->getConnection()->createStatement($sql);
		$res = $smt->getOne($arg);
		return $res['sum'] > 0 ? true : false;
	}
}