<?php

Wind::import("WINDID:service.user.validator.WindidUserValidator");
Wind::import('WINDID:library.base.WindidBaseDm');
/**
 * 用户信息数据模型
 * 
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com> 2010-11-2
 * @license http://www.phpwind.com
 * @version $Id: WindidUserDm.php 7598 2012-04-10 02:17:31Z xiaoxia.xuxx $
 * @package windid.service.user.dm
 */
class WindidUserDm extends WindidBaseDm {
	
	public $uid;
	public $oldPassword;
	public $isVerifyPwd = false;
	public $isNameChange = false;
	public $isPasswordChange = false;
	
	public function __construct($uid=0) {
		$this->uid = $uid;
	}

	public function setUid($uid) {
		$this->uid = $uid;
		return $this;
	}

	/**
	 * 设置用户名字
	 * 
	 * @param string $username
	 */
	public function setUsername($username) {
		$this->_data['username'] = $username;
		return $this;
	}

	/**
	 * 设置原密码是否-用以验证原密码
	 *
	 * @param string $oldPwd
	 * @return WindidUserDm
	 */
	public function setOldpwd($oldPwd) {
		$this->oldPassword = $oldPwd;
		$this->isVerifyPwd = true;
		return $this;
	}
	
	/**
	 * 设置用户密码
	 * 
	 * @param string $password 新密码
	 * @return WindidUserDm
	 */
	public function setPassword($password) {
		$this->isPasswordChange = true;
		$this->_data['password'] = $password;
		return $this;
	}

	/**
	 * 设置用户email
	 * 
	 * @param string $email
	 */
	public function setEmail($email) {
		$this->_data['email'] = $email;
		return $this;
	}

	/**
	 * 设置安全问题
	 * 
	 * @param string $question
	 */
	public function setQuestion($question, $answer) {
		$this->_data['safecv'] = $question ? substr(md5($question . $answer), 8, 8) : '';
		return $this;
	}

	/**
	 * 设置注册IP
	 * 
	 * @param string $regip
	 */
	public function setRegip($regip) {
		$this->_data['regip'] = $regip;
		return $this;
	}
	
	/**
	 * 设置注册时间戳
	 * 
	 * @param string $regdate
	 */
	public function setRegdate($regdate) {
		$this->_data['regdate'] = max(0, intval($regdate));
		return $this;
	}

	/**
	 * 设置性别
	 * 
	 * @param int $gender
	 */
	public function setGender($gender) {
		$this->_data['gender'] = intval($gender);
		return $this;
	}

	/**
	 * 设置生日-年
	 * 
	 * @param int $year
	 */
	public function setByear($year) {
		$this->_data['byear'] = intval($year);
		return $this;
	}
	
	/**
	 * 设置生日-月
	 * 
	 * @param string $month
	 */
	public function setBmonth($month) {
		$this->_data['bmonth'] = $month;
		return $this;
	}
	
	/**
	 * 设置生日-日
	 * 
	 * @param string $bday
	 */
	public function setBday($bday) {
		$this->_data['bday'] = $bday;
		return $this;
	}

	/**
	 * 设置家庭地址代码
	 * 
	 * @param int $hometown
	 */
	public function setHometown($hometown) {
		$this->_data['hometown'] = intval($hometown);
		return $this;
	}

	/**
	 * 设置居住地代码
	 * 
	 * @param int $location
	 */
	public function setLocation($location) {
		$this->_data['location'] = intval($location);
		return $this;
	}

	/**
	 * 设置主页
	 * 
	 * @param string $homepage
	 */
	public function setHomepage($homepage) {
		$this->_data['homepage'] = $homepage;
		return $this;
	}

	/**
	 * 设置QQ号码
	 * 
	 * @param stirng $qq
	 */
	public function setQq($qq) {
		$this->_data['qq'] = $qq;
		return $this;
	}

	/**
	 * 设置msn
	 * 
	 * @param stirng $msn
	 */
	public function setMsn($msn) {
		$this->_data['msn'] = $msn;
		return $this;
	}

	/**
	 * 设置阿里旺旺号码
	 * 
	 * @param string $aliww
	 */
	public function setAliww($aliww) {
		$this->_data['aliww'] = $aliww;
		return $this;
	}

	/**
	 * 设置手机号码
	 * 
	 * @param string $mobile
	 */
	public function setMobile($mobile) {
		$this->_data['mobile'] = $mobile;
		return $this;
	}

	/**
	 * 设置支付帐号
	 * 
	 * @param string $alipay
	 */
	public function setAlipay($alipay) {
		$this->_data['alipay'] = $alipay;
		return $this;
	}
	
	/**
	 * 
	 * 更新消息数
	 * @param int $num
	 */
	public function addMessages($num) {
		$this->_increaseData['messages'] = intval($num);
		return $this;
	}
	
	/**
	 * 设置未读消息数
	 * 
	 * @param int $messages
	 */
	public function setMessageCount($messages){
		$this->_data['messages'] = intval($messages);
	}
	
	/* (non-PHPdoc)
	 * @see WindidBaseDm::beforeAdd()
	 */
	protected function _beforeAdd() {
		if (($result = WindidUserValidator::addCheck($this)) !== true) {
			return $result;
		}
		$this->_data['salt'] = WindUtility::generateRandStr(6);
		$this->_data['password'] = WindidUtility::buildPassword($this->_data['password'], $this->_data['salt']);
		return true;
	}
	
	/* (non-PHPdoc)
	 * @see WindidBaseDm::beforeUpdate()
	 */
	protected function _beforeUpdate() {
		if (($result = WindidUserValidator::updateCheck($this)) !== true) {
			return $result;
		}
		if ($this->isNameChange) {
			//todo...
		}
		if ($this->isPasswordChange) {
			$this->_data['salt'] = WindUtility::generateRandStr(6);
			$this->_data['password'] = WindidUtility::buildPassword($this->_data['password'], $this->_data['salt']);
		}
		return true;
	}
}