CREATE TABLE `windid_app` (
  `id` SMALLINT(5) UNSIGNED NOT NULL auto_increment,
  `name` VARCHAR(30) NOT NULL DEFAULT '', 
  `siteurl` VARCHAR(128) NOT NULL DEFAULT '', 
  `secretkey` VARCHAR(50) NOT NULL DEFAULT '', 
  `apifile` VARCHAR(128) NOT NULL,
  `synlogin` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- app1为app表中的对应的id，每一个
-- TODO 待定
CREATE TABLE `windid_notify` (
  `nid` INT(10) UNSIGNED NOT NULL auto_increment,
  `app1` SMALLINT(5) UNSIGNED NOT NULL DEFAULT 0,
  `operation` VARCHAR(50) NOT NULL DEFAULT '',
  `param` VARCHAR(100) NOT NULL DEFUALT '',
  `timestamp` INT(10) NOT NULL DEFAULT 0,
  `complete` TINYINT(3) NOT NULL DEFAULT 0,
  PRIMARY KEY  (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- TableName windid_config 配置表
-- Fields name 配置名称
-- Fields namespace 配置名称空间
-- Fields value 配置值
-- Fields vtype 配置类型
-- Fields descrip 配置描述信息
-- Key namespace,name 
CREATE TABLE `windid_config` (
  `name` VARCHAR(30) NOT NULL,
  `namespace` VARCHAR(15) NOT NULL DEFAULT 'global',
  `value` TEXT NOT NULL,
  `vtype` ENUM('string','array','object') NOT NULL DEFAULT 'string',
  `descrip` TEXT NOT NULL,
  PRIMARY KEY  (`namespace`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- TableName windid_user 用户基本信息
-- Fields uid 用户ID
-- Fields username 用户名字
-- Fields email 用户email地址
-- Fields pasword 用户密码
-- Fields salt 用户密码密钥
-- Fields question 用户安全问题
-- Fields answer 用户安全问题的答案
-- Fields regdate 用户注册时间
-- Fields regip 用户注册IP
-- Key uid
-- Key idx_username 用户名唯一索引
-- Index idx_email 根据用户email索引
CREATE TABLE `windid_user` (
  `uid` INT(10) UNSIGNED NOT NULL auto_increment,
  `username` VARCHAR(15) NOT NULL DEFAULT '', 
  `email` VARCHAR(80) NOT NULL DEFAULT '', 
  `password` CHAR(32) NOT NULL DEFAULT '', 
  `salt` CHAR(6) NOT NULL DEFAULT '', 
  `question` VARCHAR(100) NOT NULL DEFAULT '', 
  `answer` VARCHAR(100) NOT NULL DEFAULT '', 
  `regdate` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `regip` VARCHAR(20) NOT NULL DEFAULT '', 
  PRIMARY KEY  (`uid`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- TableName windid_user_info 用户信息表
-- Fields uid 用户ID
-- Fields icon 用户头像
-- Fields gender 用户性别
-- Fields byear 用户出生年
-- Fields bmonth 用户出生月
-- Fields bday  用户出生日
-- Fields hometown 用户家庭地址代号
-- Fields location 用户居住地代号
-- Fields homepage 用户主页
-- Fields qq 用户QQ号码
-- Fields aliww 用户旺旺号码
-- Fields mobile 用户手机号码
-- Fields alipay 用户支付帐号
-- Key uid
CREATE TABLE `windid_user_info` (
  `uid` INT(10) UNSIGNED NOT NULL,
  `icon` VARCHAR(100) NOT NULL DEFAULT '',
  `gender` TINYINT(1) NOT NULL DEFAULT '0',
  `byear` SMALLINT(4) UNSIGNED NOT NULL DEFAULT '0',
  `bmonth` TINYINT(2) UNSIGNED NOT NULL DEFAULT '0',
  `bday` TINYINT(2) UNSIGNED NOT NULL DEFAULT '0',
  `hometown` INT(10) NOT NULL DEFAULT '0',
  `location` INT(10) NOT NULL DEFAULT '0',
  `homepage` VARCHAR(128) NOT NULL DEFAULT '',
  `qq` VARCHAR(12) NOT NULL DEFAULT '',
  `aliww` VARCHAR(30) NOT NULL DEFAULT '',
  `mobile` VARCHAR(16) NOT NULL DEFAULT '',
  `alipay` VARCHAR(80) NOT NULL DEFAULT '',
  `msn` VARCHAR(80) NOT NULL DEFAULT '',
  PRIMARY KEY  (`uid`),
  INDEX `idx_bday` (bday)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- TableName windid_user_credit 用户积分表
-- Fields uid 用户ID
-- Fields credit1 用户积分1
-- Fields credit2 用户积分2
-- Fields credit3 用户积分3
-- Fields credit4 用户积分4
-- Fields credit5 用户积分5
-- Fields credit6 用户积分6
-- Fields credit7 用户积分7
-- Fields credit8 用户积分8
-- Key uid
CREATE TABLE `windid_user_credit` (
  `uid` INT(10) UNSIGNED NOT NULL,
  `credit1` INT(10) NOT NULL DEFAULT '0',
  `credit2` INT(10) NOT NULL DEFAULT '0',
  `credit3` INT(10) NOT NULL DEFAULT '0',
  `credit4` INT(10) NOT NULL DEFAULT '0',
  `credit5` INT(10) NOT NULL DEFAULT '0',
  `credit6` INT(10) NOT NULL DEFAULT '0',
  `credit7` INT(10) NOT NULL DEFAULT '0',
  `credit8` INT(10) NOT NULL DEFAULT '0',
  PRIMARY KEY  (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;