/*!
 * PHPWind UI Library
 * @Copyright   : Copyright 2011, phpwind.com
 * @Descript    : 相册增删改
 * @Author      : siweiran@gmail.com
 * @Depend      : core.js、jquery.js(1.7 or later)
 * $Id: dialog.js 8433 2012-04-18 12:23:53Z chris.chencq $:
 */
$(function() {
	var newAlbumData= [];
	if($.browser.msie && $.browser.version == "6.0"){
		$("#album_home li").hover(function(){
			$(this).find(".operate").show();
		},function(){
			$(this).find(".operate").hide();
		})
	}
    function showAjaxData(url, data, type, dataType, sucCallBack) {
        $.ajax({
            url: url,
            data: data,
            type: type ? type : "POST",
            dataType: dataType,
            success: function(data) {
                sucCallBack(data);
            },
            error: function() {
                Wind.Util.resultTip({
                    error: true,
                    msg: "请求出错,请重试",
                    follow: false
                });
            }
        })
    }

    //限制字符 不区分中英文字符数
    function check(obj, num) {
        var $obj = obj,
            max = $obj.attr('maxlength') || num,
            $info = $obj.next(),
            objVal = $obj.val().length;
        if (objVal > 0) {
            $info.html('<b>' + objVal + "</b>/" + max);
        }
        $obj.bind('keyup change', function() {
            var _val = $(this).val(),
                _curL = _val.length;
            if (_curL == 0) {
                $info.html("0/" + max);
            } else if (_curL < max) {
                $info.html(_curL + "/" + max);
            } else {
                $info.html('<b style="color:#f30">' + _curL + "</b>/" + max);
            }
        })
    }
    //新建相册
    $("#J_new_album").click(function(e) {
        e.preventDefault();
        var $this = $(this),
            url = $this.attr("href"),
            submitF = $this.attr("data-callback");
        var callback = function(data) {
                if (ajaxTempError(data)) {
                	newAlbumData['albumDialog']=data;
                	newAlbum(newAlbumData['albumDialog'],callBackObj[submitF]);
                }
            }
        if (newAlbumData['albumDialog']) {
        	newAlbum(newAlbumData['albumDialog'],callBackObj[submitF]);
        } else {
            showAjaxData(url, null, "GET", "html", callback);
        }
    })

function newAlbum(data,call){
        Wind.dialog.html(data, {
            position: 'fixed',
            title: '创建相册',
            isMask: false,
            isDrag: true,
            callback: function() {
                var $form = $("#J_newAlbum_form"),
                    albumName = $form.find("input[name=name]"),
                    albumDescrip = $form.find("textarea[name=descrip]"),
                    albumSubmit = $("#btn_add_newAlbum");

                buttonStatus(albumName,albumSubmit);
                //即时显示字数
                check(albumName, 10) || check(albumDescrip, 100);
                albumSubmit.on('click', function(e) {
                    e.preventDefault();
                    $(this).addClass('disabled').attr('disabled','disabled').text('正在提交..');
                    var desc = albumDescrip.val();
                    if(desc.length>100){
                    	$("#errorTitle").show().html("相册描述不能超出100个字");
                    	return false;
                    }else{
                    	call();
                    }
                })
            }
        })
    }
    //callBackObj用于封装新建相册点击"确定"的回调
    var callBackObj = {
        postData: function(){
            var $form = $("#J_newAlbum_form"),
                formData = $form.serialize(),
                url = $form.attr('action');
            var callBack = function(data) {
                    if (data.state === "success") {
                        Wind.Util.resultTip({
                            msg: "新建相册成功"
                        });
                        reloadPage(window);
                    } else {
                        Wind.Util.resultTip({
                            error: true,
                            msg: data.message[0],
                            follow: false
                        });
                    }
                }
            showAjaxData(url, formData, null, 'json', callBack);
        },
        addForUpdate: function() {
            var $form = $("#J_newAlbum_form"),
                formData = $form.serialize(),
                url = $form.attr('action'),
                $J_album_list = $("#J_album_list");
            var callBack = function(data) {
                    if (data.state === "success") {
                        var obj = data.data,
                            html = '<option data-num="' + obj.num + '" value="' + obj.albumid + '">' + obj.name + '</option>';
                        $J_album_list.append(html);
                        $J_album_list.find("option[value=" + obj.albumid + "]").attr("selected",true);
                        Wind.Util.resultTip({
                            msg: "新建相册成功"
                        })
                        Wind.dialog.closeAll();
                        updateList();//刷新当前待上传列表
                    } else {
                        Wind.Util.resultTip({
                            error: true,
                            msg: data.message[0],
                            follow: false
                        });
                        this.removeClass('disabled').removeAttr('disabled','disabled').text('提交');
                    }
                }
            showAjaxData(url, formData, null, 'json', callBack);
        }
    }

    //删除相册
    $("#album_home li .del").click(function(e) {
        e.preventDefault();
        var $this = $(this),
            photoNum = $this.data("photo"),
            $delId = $this.attr("data-del"),
            url = $this.prop('href');
        if (photoNum > 0) {
            ajaxConfirm({
                elem: $this,
                href: url,
                msg: "删除相册的同时会删除该相册下的照片，确认删除?",
                callback: function() {
                    Wind.Util.resultTip({
                        msg: '删除成功'
                    });
                    $("#album" + $delId).fadeOut();
                }
            });
        } else {
            var callback = function(data) {
                    if (data.state === "success") {
                        Wind.Util.resultTip({
                            msg: '删除成功'
                        });
                        $("#album" + $delId).fadeOut();
                    } else {
                        Wind.Util.resultTip({
                            error: true,
                            msg: data.message[0]
                        });
                    }
                }
            showAjaxData(url, null, "GET", 'json', callback);
        }
    })

    //编辑相册
    $("#album_home li .edit").click(function(e) {
        e.preventDefault();
        var $this = $(this),
            url = $this.attr("href");
        var callback = function(data) {
                if (ajaxTempError(data)) {
                    Wind.dialog.html(data, {
                        position: 'fixed',
                        title: '编辑相册',
                        isMask: false,
                        isDrag: true,
                        callback: function(){
                            var $form = $("#J_editAlbum_form");
                            sendEditData($form);
                        }
                    })
                }
            }
        showAjaxData(url, null, "GET", 'html', callback);
    })

    function sendEditData($obj) {
            var $sub = $("#btn_edit_newAlbum"),
                albumName = $obj.find("input[name=name]"),
                textarea = $obj.find("textarea[name=descrip]"),
               callBack = function(data) {
                    if (data.state === "success") {
                        Wind.Util.resultTip({
                            msg: '修改成功'
                        });
                        reloadPage(window);
                    } else {
                        Wind.Util.resultTip({
                            error: true,
                            msg: data.message[0],
                            follow: false
                        });
                    }
                };
            check(albumName, 10) || check(textarea, 100);
            $sub.on('click', function(e) {
                e.preventDefault();
                console.log(albumName.val().length==0)
                var url = $obj.attr("action"),
                    formData = $obj.serialize();
                if(albumName.val().length==0){
                	$("#errorTitle").show().html("相册名称不能为空");
                }else if(textarea.val().length>100){
                	$("#errorTitle").show().html("相册描述不能超出100个字");
                }else{
                    showAjaxData(url, formData, null, 'json', callBack);
                }
            })
        }
})